/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSurfMultiSpectral;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.MultiSpectral;

public class SurfMultiSpectral_to_DescribeRegionPoint<T extends ImageSingleBand, II extends ImageSingleBand>
implements DescribeRegionPoint<MultiSpectral<T>, BrightFeature> {
    DescribePointSurfMultiSpectral<II> alg;
    T gray;
    II grayII;
    MultiSpectral<II> bandII;
    ImageType<MultiSpectral<T>> imageType;

    public SurfMultiSpectral_to_DescribeRegionPoint(DescribePointSurfMultiSpectral<II> alg, Class<T> imageType, Class<II> integralType) {
        this.alg = alg;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.grayII = GeneralizedImageOps.createSingleBand(integralType, (int)1, (int)1);
        this.bandII = new MultiSpectral(integralType, 1, 1, alg.getNumBands());
        this.imageType = ImageType.ms((int)alg.getNumBands(), imageType);
    }

    @Override
    public void setImage(MultiSpectral<T> image) {
        this.gray.reshape(image.width, image.height);
        this.grayII.reshape(image.width, image.height);
        this.bandII.reshape(image.width, image.height);
        GConvertImage.average(image, this.gray);
        GIntegralImageOps.transform(this.gray, this.grayII);
        for (int i = 0; i < image.getNumBands(); ++i) {
            GIntegralImageOps.transform((ImageSingleBand)image.getBand(i), (ImageSingleBand)this.bandII.getBand(i));
        }
        this.alg.setImage(this.grayII, this.bandII);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, BrightFeature description) {
        this.alg.describe(x, y, orientation, radius / 2.0, description);
        return true;
    }

    @Override
    public boolean requiresRadius() {
        return true;
    }

    @Override
    public boolean requiresOrientation() {
        return true;
    }

    @Override
    public ImageType<MultiSpectral<T>> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.alg.getDescribe().getCanonicalWidth();
    }

    @Override
    public BrightFeature createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }
}

