/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.feature.detdesc.DetectDescribeSurfMultiSpectral;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.point.Point2D_F64;

public class SurfMultiSpectral_to_DetectDescribePoint<T extends ImageSingleBand, II extends ImageSingleBand>
implements DetectDescribePoint<MultiSpectral<T>, BrightFeature> {
    DetectDescribeSurfMultiSpectral<II> alg;
    T gray;
    II grayII;
    MultiSpectral<II> bandII;

    public SurfMultiSpectral_to_DetectDescribePoint(DetectDescribeSurfMultiSpectral<II> alg, Class<T> imageType, Class<II> integralType) {
        this.alg = alg;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.grayII = GeneralizedImageOps.createSingleBand(integralType, (int)1, (int)1);
        this.bandII = new MultiSpectral(integralType, 1, 1, alg.getDescribe().getNumBands());
    }

    @Override
    public void detect(MultiSpectral<T> input) {
        this.gray.reshape(input.width, input.height);
        this.grayII.reshape(input.width, input.height);
        this.bandII.reshape(input.width, input.height);
        GConvertImage.average(input, this.gray);
        GIntegralImageOps.transform(this.gray, this.grayII);
        for (int i = 0; i < input.getNumBands(); ++i) {
            GIntegralImageOps.transform((ImageSingleBand)input.getBand(i), (ImageSingleBand)this.bandII.getBand(i));
        }
        this.alg.detect(this.grayII, this.bandII);
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return true;
    }

    @Override
    public BrightFeature getDescription(int index) {
        return this.alg.getDescription(index);
    }

    @Override
    public BrightFeature createDescription() {
        return this.alg.createDescription();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }

    @Override
    public int getNumberOfFeatures() {
        return this.alg.getNumberOfFeatures();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return this.alg.getLocation(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.alg.getRadius(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.alg.getOrientation(featureIndex);
    }
}

