/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.orientation;

import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.interest.UnrollSiftScaleSpaceGradient;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.core.image.GConvertImage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public class OrientationSiftToImage<T extends ImageSingleBand>
implements OrientationImage<T> {
    UnrollSiftScaleSpaceGradient scaleSpace;
    OrientationHistogramSift<ImageFloat32> alg;
    UnrollSiftScaleSpaceGradient.ImageScale image;
    double sigma = 1.0;
    Class<T> imageType;
    ImageFloat32 imageFloat = new ImageFloat32(1, 1);

    public OrientationSiftToImage(OrientationHistogramSift<ImageFloat32> alg, SiftScaleSpace ss, Class<T> imageType) {
        this.alg = alg;
        this.scaleSpace = new UnrollSiftScaleSpaceGradient(ss);
        this.imageType = imageType;
    }

    @Override
    public void setImage(T image) {
        ImageFloat32 input;
        if (image instanceof ImageFloat32) {
            input = (ImageFloat32)image;
        } else {
            this.imageFloat.reshape(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
            GConvertImage.convert(image, (ImageBase)this.imageFloat);
            input = this.imageFloat;
        }
        this.scaleSpace.setImage(input);
        this.setObjectRadius(this.sigma * 1.0);
    }

    @Override
    public Class<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void setObjectRadius(double radius) {
        this.sigma = radius / 1.0;
        this.image = this.scaleSpace.lookup(this.sigma);
    }

    @Override
    public double compute(double c_x, double c_y) {
        this.alg.setImageGradient(this.image.derivX, this.image.derivY);
        double imageToInput = this.image.imageToInput;
        this.alg.process(c_x / imageToInput, c_y / imageToInput, this.sigma / imageToInput);
        return this.alg.getPeakOrientation();
    }
}

