/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PointTransformModel_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingBasic_SB<T extends ImageSingleBand, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<T, Motion> {
    protected ImageFloat32 background = new ImageFloat32(1, 1);
    protected InterpolatePixelS<T> interpolateInput;
    protected InterpolatePixelS<ImageFloat32> interpolationBG;
    protected GImageSingleBand inputWrapper;

    public BackgroundMovingBasic_SB(float learnRate, float threshold, PointTransformModel_F32<Motion> transform, TypeInterpolate interpType, Class<T> imageType) {
        super(learnRate, threshold, transform, ImageType.single(imageType));
        this.interpolateInput = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)BorderType.EXTENDED);
        this.interpolationBG = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (TypeInterpolate)interpType, (BorderType)BorderType.EXTENDED, ImageFloat32.class);
        this.interpolationBG.setBorder(FactoryImageBorder.single(ImageFloat32.class, (BorderType)BorderType.EXTENDED));
        this.interpolationBG.setImage((ImageBase)this.background);
        this.inputWrapper = FactoryGImageSingleBand.create(imageType);
    }

    public ImageFloat32 getBackground() {
        return this.background;
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        ImageMiscOps.fill((ImageFloat32)this.background, (float)Float.MAX_VALUE);
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        ImageMiscOps.fill((ImageFloat32)this.background, (float)Float.MAX_VALUE);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolateInput.setImage(frame);
        float minusLearn = 1.0f - this.learnRate;
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0;
            int x = x0;
            while (x < x1) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)((ImageSingleBand)frame).width && this.work.y >= 0.0f && this.work.y < (float)((ImageSingleBand)frame).height) {
                    float value = this.interpolateInput.get(this.work.x, this.work.y);
                    float bg = this.background.data[indexBG];
                    this.background.data[indexBG] = bg == Float.MAX_VALUE ? value : minusLearn * bg + this.learnRate * value;
                }
                ++x;
                ++indexBG;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, ImageUInt8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        float thresholdSq = this.threshold * this.threshold;
        for (int y = 0; y < ((ImageSingleBand)frame).height; ++y) {
            int indexFrame = ((ImageSingleBand)frame).startIndex + y * ((ImageSingleBand)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageSingleBand)frame).width) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                    float diff;
                    float bg = this.interpolationBG.get(this.work.x, this.work.y);
                    float pixelFrame = this.inputWrapper.getF(indexFrame);
                    segmented.data[indexSegmented] = bg == Float.MAX_VALUE ? this.unknownValue : ((diff = bg - pixelFrame) * diff <= thresholdSq ? (byte)0 : 1);
                } else {
                    segmented.data[indexSegmented] = this.unknownValue;
                }
                ++x;
                ++indexFrame;
                ++indexSegmented;
            }
        }
    }
}

