/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PointTransformModel_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingGaussian_SB<T extends ImageSingleBand, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGaussian<T, Motion> {
    protected InterpolatePixelS<T> interpolateInput;
    protected InterpolatePixelMB<MultiSpectral<ImageFloat32>> interpolationBG;
    protected GImageSingleBand inputWrapper;
    protected float[] pixelBG = new float[2];
    MultiSpectral<ImageFloat32> background = new MultiSpectral(ImageFloat32.class, 1, 1, 2);

    public BackgroundMovingGaussian_SB(float learnRate, float threshold, PointTransformModel_F32<Motion> transform, TypeInterpolate interpType, Class<T> imageType) {
        super(learnRate, threshold, transform, ImageType.single(imageType));
        this.interpolateInput = FactoryInterpolation.bilinearPixelS(imageType, (BorderType)BorderType.EXTENDED);
        this.interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (TypeInterpolate)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.ms((int)2, ImageFloat32.class));
        this.interpolationBG.setImage(this.background);
        this.inputWrapper = FactoryGImageSingleBand.create(imageType);
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background.getBand(0), (double)0.0);
        GImageMiscOps.fill((ImageBase)this.background.getBand(1), (double)-1.0);
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill((ImageBase)this.background.getBand(0), (double)0.0);
        GImageMiscOps.fill((ImageBase)this.background.getBand(1), (double)-1.0);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolateInput.setImage(frame);
        float minusLearn = 1.0f - this.learnRate;
        ImageFloat32 backgroundMean = (ImageFloat32)this.background.getBand(0);
        ImageFloat32 backgroundVar = (ImageFloat32)this.background.getBand(1);
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0;
            int x = x0;
            while (x < x1) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)((ImageSingleBand)frame).width && this.work.y >= 0.0f && this.work.y < (float)((ImageSingleBand)frame).height) {
                    float inputValue = this.interpolateInput.get(this.work.x, this.work.y);
                    float meanBG = backgroundMean.data[indexBG];
                    float varianceBG = backgroundVar.data[indexBG];
                    if (varianceBG < 0.0f) {
                        backgroundMean.data[indexBG] = inputValue;
                        backgroundVar.data[indexBG] = this.initialVariance;
                    } else {
                        float diff = meanBG - inputValue;
                        backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                        backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                    }
                }
                ++x;
                ++indexBG;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, ImageUInt8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        for (int y = 0; y < ((ImageSingleBand)frame).height; ++y) {
            int indexFrame = ((ImageSingleBand)frame).startIndex + y * ((ImageSingleBand)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageSingleBand)frame).width) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                    float diff;
                    float chisq;
                    this.interpolationBG.get(this.work.x, this.work.y, this.pixelBG);
                    float pixelFrame = this.inputWrapper.getF(indexFrame);
                    float meanBG = this.pixelBG[0];
                    float varBG = this.pixelBG[1];
                    segmented.data[indexSegmented] = varBG < 0.0f ? this.unknownValue : ((chisq = (diff = meanBG - pixelFrame) * diff / varBG) <= this.threshold ? (byte)0 : (diff > this.minimumDifference || -diff > this.minimumDifference ? (byte)1 : 0));
                } else {
                    segmented.data[indexSegmented] = this.unknownValue;
                }
                ++x;
                ++indexFrame;
                ++indexSegmented;
            }
        }
    }
}

