/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageSingleBand;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;

public class BackgroundStationaryBasic_SB<T extends ImageSingleBand>
extends BackgroundStationaryBasic<T> {
    protected ImageFloat32 background = new ImageFloat32(1, 1);
    protected GImageSingleBand inputWrapper;

    public BackgroundStationaryBasic_SB(float learnRate, float threshold, Class<T> imageType) {
        super(learnRate, threshold, ImageType.single(imageType));
        this.inputWrapper = FactoryGImageSingleBand.create(imageType);
    }

    public ImageFloat32 getBackground() {
        return this.background;
    }

    @Override
    public void reset() {
        this.background.reshape(1, 1);
    }

    @Override
    public void updateBackground(T frame) {
        if (this.background.width == 1) {
            this.background.reshape(((ImageSingleBand)frame).width, ((ImageSingleBand)frame).height);
            GConvertImage.convert(frame, (ImageBase)this.background);
            return;
        }
        InputSanityCheck.checkSameShape((ImageBase)this.background, frame);
        this.inputWrapper.wrap(frame);
        float minusLearn = 1.0f - this.learnRate;
        int indexBG = 0;
        for (int y = 0; y < ((ImageSingleBand)frame).height; ++y) {
            int indexInput = ((ImageSingleBand)frame).startIndex + y * ((ImageSingleBand)frame).stride;
            int end = indexInput + ((ImageSingleBand)frame).width;
            while (indexInput < end) {
                float value = this.inputWrapper.getF(indexInput++);
                float bg = this.background.data[indexBG];
                this.background.data[indexBG++] = minusLearn * bg + this.learnRate * value;
            }
        }
    }

    @Override
    public void segment(T frame, ImageUInt8 segmented) {
        if (this.background.width == 1) {
            ImageMiscOps.fill((ImageInt8)segmented, (int)this.unknownValue);
            return;
        }
        InputSanityCheck.checkSameShape((ImageBase)this.background, frame, (ImageBase)segmented);
        this.inputWrapper.wrap(frame);
        float thresholdSq = this.threshold * this.threshold;
        int indexBG = 0;
        for (int y = 0; y < ((ImageSingleBand)frame).height; ++y) {
            int indexInput = ((ImageSingleBand)frame).startIndex + y * ((ImageSingleBand)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + ((ImageSingleBand)frame).width;
            while (indexInput < end) {
                float bg = this.background.data[indexBG];
                float pixelFrame = this.inputWrapper.getF(indexInput);
                float diff = bg - pixelFrame;
                segmented.data[indexSegmented] = diff * diff <= thresholdSq ? (byte)0 : 1;
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        }
    }
}

