/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageSingleBand;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class BackgroundStationaryGaussian_SB<T extends ImageSingleBand>
extends BackgroundStationaryGaussian<T> {
    protected GImageSingleBand inputWrapper;
    MultiSpectral<ImageFloat32> background = new MultiSpectral(ImageFloat32.class, 1, 1, 2);

    public BackgroundStationaryGaussian_SB(float learnRate, float threshold, Class<T> imageType) {
        super(learnRate, threshold, ImageType.single(imageType));
        this.inputWrapper = FactoryGImageSingleBand.create(imageType);
    }

    @Override
    public void reset() {
        this.background.reshape(1, 1);
    }

    @Override
    public void updateBackground(T frame) {
        if (this.background.width == 1) {
            this.background.reshape(((ImageSingleBand)frame).width, ((ImageSingleBand)frame).height);
            GConvertImage.convert(frame, (ImageBase)this.background.getBand(0));
            GImageMiscOps.fill((ImageBase)this.background.getBand(1), (double)this.initialVariance);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame);
        this.inputWrapper.wrap(frame);
        float minusLearn = 1.0f - this.learnRate;
        ImageFloat32 backgroundMean = (ImageFloat32)this.background.getBand(0);
        ImageFloat32 backgroundVar = (ImageFloat32)this.background.getBand(1);
        int indexBG = 0;
        for (int y = 0; y < this.background.height; ++y) {
            int indexInput;
            int end = indexInput + ((ImageSingleBand)frame).width;
            for (indexInput = ((ImageSingleBand)frame).startIndex + y * ((ImageSingleBand)frame).stride; indexInput < end; ++indexInput) {
                float inputValue = this.inputWrapper.getF(indexInput);
                float meanBG = backgroundMean.data[indexBG];
                float varianceBG = backgroundVar.data[indexBG];
                float diff = meanBG - inputValue;
                backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                ++indexBG;
            }
        }
    }

    @Override
    public void segment(T frame, ImageUInt8 segmented) {
        if (this.background.width == 1) {
            ImageMiscOps.fill((ImageInt8)segmented, (int)this.unknownValue);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame, (ImageBase)segmented);
        this.inputWrapper.wrap(frame);
        ImageFloat32 backgroundMean = (ImageFloat32)this.background.getBand(0);
        ImageFloat32 backgroundVar = (ImageFloat32)this.background.getBand(1);
        int indexBG = 0;
        for (int y = 0; y < ((ImageSingleBand)frame).height; ++y) {
            int indexInput = ((ImageSingleBand)frame).startIndex + y * ((ImageSingleBand)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + ((ImageSingleBand)frame).width;
            while (indexInput < end) {
                float varBG;
                float meanBG = backgroundMean.data[indexBG];
                float pixelFrame = this.inputWrapper.getF(indexInput);
                float diff = meanBG - pixelFrame;
                float chisq = diff * diff / (varBG = backgroundVar.data[indexBG]);
                segmented.data[indexSegmented] = chisq <= this.threshold ? (byte)0 : (diff >= this.minimumDifference || -diff >= this.minimumDifference ? (byte)1 : 0);
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        }
    }
}

