/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.struct.image.ImageSingleBand;

public abstract class DescribePointRectangleRegion<T extends ImageSingleBand> {
    protected T image;
    protected int regionWidth;
    protected int regionHeight;
    protected int radiusWidth;
    protected int radiusHeight;
    protected int[] offset;

    public DescribePointRectangleRegion(int regionWidth, int regionHeight) {
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.radiusWidth = regionWidth / 2;
        this.radiusHeight = regionHeight / 2;
        this.offset = new int[regionHeight * regionWidth];
    }

    public void setImage(T image) {
        this.image = image;
        for (int i = 0; i < this.regionHeight; ++i) {
            for (int j = 0; j < this.regionWidth; ++j) {
                this.offset[i * this.regionWidth + j] = (i - this.radiusHeight) * ((ImageSingleBand)image).stride + j - this.radiusWidth;
            }
        }
    }

    public int getDescriptorLength() {
        return this.offset.length;
    }

    public int getRegionWidth() {
        return this.regionWidth;
    }

    public int getRegionHeight() {
        return this.regionHeight;
    }
}

