/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageFloat32;

public abstract class NonMaxBlock {
    protected int radius;
    protected float thresholdMin;
    protected float thresholdMax;
    protected int border;
    int endX;
    int endY;
    protected QueueCorner localMin;
    protected QueueCorner localMax;
    public boolean detectsMinimum;
    public boolean detectsMaximum;

    protected NonMaxBlock(boolean detectsMinimum, boolean detectsMaximum) {
        this.detectsMinimum = detectsMinimum;
        this.detectsMaximum = detectsMaximum;
    }

    public void process(ImageFloat32 intensityImage, QueueCorner localMin, QueueCorner localMax) {
        this.localMin = localMin;
        this.localMax = localMax;
        this.endX = intensityImage.width - this.border;
        this.endY = intensityImage.height - this.border;
        int step = this.radius + 1;
        for (int y = this.border; y < this.endY; y += step) {
            int y1 = y + step;
            if (y1 > this.endY) {
                y1 = this.endY;
            }
            for (int x = this.border; x < this.endX; x += step) {
                int x1 = x + step;
                if (x1 > this.endX) {
                    x1 = this.endX;
                }
                this.searchBlock(x, y, x1, y1, intensityImage);
            }
        }
    }

    protected abstract void searchBlock(int var1, int var2, int var3, int var4, ImageFloat32 var5);

    public void setSearchRadius(int radius) {
        this.radius = radius;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public int getSearchRadius() {
        return this.radius;
    }

    public float getThresholdMin() {
        return this.thresholdMin;
    }

    public void setThresholdMin(float thresholdMin) {
        this.thresholdMin = thresholdMin;
    }

    public float getThresholdMax() {
        return this.thresholdMax;
    }

    public void setThresholdMax(float thresholdMax) {
        this.thresholdMax = thresholdMax;
    }
}

