/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import java.util.ArrayList;
import java.util.List;

public class UnrollSiftScaleSpaceGradient {
    SiftScaleSpace scaleSpace;
    List<ImageScale> usedScales = new ArrayList<ImageScale>();
    List<ImageScale> allScales = new ArrayList<ImageScale>();
    ImageGradient<ImageFloat32, ImageFloat32> gradient = FactoryDerivative.three_F32();

    public UnrollSiftScaleSpaceGradient(SiftScaleSpace scaleSpace) {
        this.scaleSpace = scaleSpace;
        int numScales = scaleSpace.getNumScales() * scaleSpace.getTotalOctaves();
        for (int i = 0; i < numScales; ++i) {
            this.allScales.add(new ImageScale());
        }
    }

    public void setImage(ImageFloat32 image) {
        this.scaleSpace.initialize(image);
        this.usedScales.clear();
        do {
            for (int i = 0; i < this.scaleSpace.getNumScales(); ++i) {
                ImageFloat32 scaleImage = this.scaleSpace.getImageScale(i);
                double sigma = this.scaleSpace.computeSigmaScale(i);
                double pixelCurrentToInput = this.scaleSpace.pixelScaleCurrentToInput();
                ImageScale scale = this.allScales.get(this.usedScales.size());
                scale.derivX.reshape(scaleImage.width, scaleImage.height);
                scale.derivY.reshape(scaleImage.width, scaleImage.height);
                this.gradient.process((ImageBase)scaleImage, (ImageBase)scale.derivX, (ImageBase)scale.derivY);
                scale.imageToInput = pixelCurrentToInput;
                scale.sigma = sigma;
                this.usedScales.add(scale);
            }
        } while (this.scaleSpace.computeNextOctave());
    }

    public ImageScale lookup(double sigma) {
        ImageScale best = null;
        double bestValue = Double.MAX_VALUE;
        for (int i = 0; i < this.usedScales.size(); ++i) {
            ImageScale image = this.usedScales.get(i);
            double difference = Math.abs(sigma - image.sigma);
            if (!(difference < bestValue)) continue;
            bestValue = difference;
            best = image;
        }
        return best;
    }

    public static class ImageScale {
        public ImageFloat32 derivX = new ImageFloat32(1, 1);
        public ImageFloat32 derivY = new ImageFloat32(1, 1);
        public double imageToInput;
        public double sigma;
    }
}

