/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.fh04.impl;

import boofcv.alg.segmentation.fh04.FhEdgeWeights;
import boofcv.alg.segmentation.fh04.SegmentFelzenszwalbHuttenlocher04;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.FastQueue;

public class FhEdgeWeights4_F32
implements FhEdgeWeights<ImageFloat32> {
    @Override
    public void process(ImageFloat32 input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int y;
        int w = input.width - 1;
        int h = input.height - 1;
        for (y = 0; y < h; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 0;
            int indexDst = y * input.width + 0;
            int x = 0;
            while (x < w) {
                float color0 = input.data[indexSrc];
                float color1 = input.data[indexSrc + 1];
                float color2 = input.data[indexSrc + input.stride];
                SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                SegmentFelzenszwalbHuttenlocher04.Edge e2 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                e1.sortValue = Math.abs(color1 - color0);
                e1.indexA = indexDst;
                e1.indexB = indexDst + 1;
                e2.sortValue = Math.abs(color2 - color0);
                e2.indexA = indexDst;
                e2.indexB = indexDst + input.width;
                ++x;
                ++indexSrc;
                ++indexDst;
            }
        }
        for (y = 0; y < h; ++y) {
            this.checkAround(w, y, input, edges);
        }
        for (int x = 0; x < w; ++x) {
            this.checkAround(x, h, input, edges);
        }
    }

    private void checkAround(int x, int y, ImageFloat32 input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexA = y * input.width + x;
        float color0 = input.data[indexSrc];
        this.check(x + 1, y, color0, indexA, input, edges);
        this.check(x, y + 1, color0, indexA, input, edges);
    }

    private void check(int x, int y, float color0, int indexA, ImageFloat32 input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        if (!input.isInBounds(x, y)) {
            return;
        }
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexB = y * input.width + x;
        float colorN = input.data[indexSrc];
        SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
        e1.sortValue = Math.abs(color0 - colorN);
        e1.indexA = indexA;
        e1.indexB = indexB;
    }

    @Override
    public ImageType<ImageFloat32> getInputType() {
        return ImageType.single(ImageFloat32.class);
    }
}

