/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.edge;

import boofcv.alg.interpolate.ImageLineIntegral;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.core.image.GImageSingleBandDistorted;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageSingleBand;

public class BaseIntegralEdge<T extends ImageSingleBand> {
    Class<T> imageType;
    protected ImageLineIntegral integral;
    protected GImageSingleBand integralImage;

    public BaseIntegralEdge(Class<T> imageType) {
        this.imageType = imageType;
        this.integral = new ImageLineIntegral();
        this.integralImage = FactoryGImageSingleBand.create(imageType);
    }

    public void setTransform(PixelTransform_F32 undistToDist) {
        InterpolatePixelS interpolate = FactoryInterpolation.bilinearPixelS(this.imageType, (BorderType)BorderType.EXTENDED);
        this.integralImage = new GImageSingleBandDistorted(undistToDist, interpolate);
    }

    public void setImage(T image) {
        this.integralImage.wrap(image);
        this.integral.setImage(this.integralImage);
    }
}

