/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.describe.ConfigBrief;
import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.describe.DescribeRegionPoint_SIFT;
import boofcv.abst.feature.describe.SurfMultiSpectral_to_DescribeRegionPoint;
import boofcv.abst.feature.describe.WrapDescribeBrief;
import boofcv.abst.feature.describe.WrapDescribeBriefSo;
import boofcv.abst.feature.describe.WrapDescribePixelRegion;
import boofcv.abst.feature.describe.WrapDescribePixelRegionNCC;
import boofcv.abst.feature.describe.WrapDescribeSurf;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfMultiSpectral;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.alg.feature.describe.brief.FactoryBriefDefinition;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import java.util.Random;

public class FactoryDescribeRegionPoint {
    public static <T extends ImageSingleBand, II extends ImageSingleBand> DescribeRegionPoint<T, BrightFeature> surfFast(ConfigSurfDescribe.Speed config, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurf alg = FactoryDescribePointAlgs.surfSpeed(config, integralType);
        return new WrapDescribeSurf(alg, imageType);
    }

    public static <T extends ImageMultiBand, II extends ImageSingleBand> DescribeRegionPoint<T, BrightFeature> surfColorFast(ConfigSurfDescribe.Speed config, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        DescribePointSurf alg = FactoryDescribePointAlgs.surfSpeed(config, integralType);
        if (imageType.getFamily() == ImageType.Family.MULTI_SPECTRAL) {
            DescribePointSurfMultiSpectral color = FactoryDescribePointAlgs.surfColor(alg, imageType.getNumBands());
            return new SurfMultiSpectral_to_DescribeRegionPoint(color, bandType, integralType);
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageSingleBand, II extends ImageSingleBand> DescribeRegionPoint<T, BrightFeature> surfStable(ConfigSurfDescribe.Stability config, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        DescribePointSurfMod alg = FactoryDescribePointAlgs.surfStability(config, integralType);
        return new WrapDescribeSurf(alg, imageType);
    }

    public static <T extends ImageBase, II extends ImageSingleBand> DescribeRegionPoint<T, BrightFeature> surfColorStable(ConfigSurfDescribe.Stability config, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        DescribePointSurfMod alg = FactoryDescribePointAlgs.surfStability(config, integralType);
        if (imageType.getFamily() == ImageType.Family.MULTI_SPECTRAL) {
            DescribePointSurfMultiSpectral color = FactoryDescribePointAlgs.surfColor(alg, imageType.getNumBands());
            return new SurfMultiSpectral_to_DescribeRegionPoint(color, bandType, integralType);
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageSingleBand> DescribeRegionPoint<T, TupleDesc_F64> sift(ConfigSiftScaleSpace configSS, ConfigSiftDescribe configDescribe, Class<T> imageType) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        configSS.checkValidity();
        SiftScaleSpace ss = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        DescribePointSift<ImageFloat32> alg = FactoryDescribePointAlgs.sift(configDescribe, ImageFloat32.class);
        return new DescribeRegionPoint_SIFT<T>(ss, alg, imageType);
    }

    public static <T extends ImageSingleBand> DescribeRegionPoint<T, TupleDesc_B> brief(ConfigBrief config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigBrief();
        }
        config.checkValidity();
        BlurStorageFilter filter = FactoryBlurFilter.gaussian(imageType, (double)config.blurSigma, (int)config.blurRadius);
        BinaryCompareDefinition_I32 definition = FactoryBriefDefinition.gaussian2(new Random(123L), config.radius, config.numPoints);
        if (config.fixed) {
            return new WrapDescribeBrief(FactoryDescribePointAlgs.brief(definition, filter), imageType);
        }
        return new WrapDescribeBriefSo(FactoryDescribePointAlgs.briefso(definition, filter), imageType);
    }

    public static <T extends ImageSingleBand, D extends TupleDesc> DescribeRegionPoint<T, D> pixel(int regionWidth, int regionHeight, Class<T> imageType) {
        return new WrapDescribePixelRegion(FactoryDescribePointAlgs.pixelRegion(regionWidth, regionHeight, imageType), imageType);
    }

    public static <T extends ImageSingleBand> DescribeRegionPoint<T, NccFeature> pixelNCC(int regionWidth, int regionHeight, Class<T> imageType) {
        return new WrapDescribePixelRegionNCC<T>(FactoryDescribePointAlgs.pixelRegionNCC(regionWidth, regionHeight, imageType), imageType);
    }
}

