/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.GeneralToInterestPoint;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.detect.interest.WrapFHtoInterestPoint;
import boofcv.abst.feature.detect.interest.WrapFLPtoInterestPoint;
import boofcv.abst.feature.detect.interest.WrapFPtoInterestPoint;
import boofcv.abst.feature.detect.interest.WrapSiftDetector;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.interest.FeatureLaplacePyramid;
import boofcv.alg.feature.detect.interest.FeaturePyramid;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.PyramidFloat;

public class FactoryInterestPoint {
    public static <T extends ImageSingleBand, D extends ImageSingleBand> InterestPointDetector<T> wrapPoint(GeneralFeatureDetector<T, D> feature, double scale, Class<T> inputType, Class<D> derivType) {
        ImageGradient gradient = null;
        ImageHessian hessian = null;
        if (feature.getRequiresGradient() || feature.getRequiresHessian()) {
            gradient = FactoryDerivative.sobel(inputType, derivType);
        }
        if (feature.getRequiresHessian()) {
            hessian = FactoryDerivative.hessianSobel(derivType);
        }
        return new GeneralToInterestPoint<T, D>(feature, gradient, hessian, scale, derivType);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> InterestPointDetector<T> wrapDetector(FeatureLaplacePyramid<T, D> feature, double[] scales, boolean pyramid, Class<T> inputType) {
        PyramidFloat ss = pyramid ? FactoryPyramid.scaleSpacePyramid((double[])scales, inputType) : FactoryPyramid.scaleSpace((double[])scales, inputType);
        return new WrapFLPtoInterestPoint<T, D>(feature, ss);
    }

    public static <T extends ImageSingleBand, D extends ImageSingleBand> InterestPointDetector<T> wrapDetector(FeaturePyramid<T, D> feature, double[] scales, boolean pyramid, Class<T> inputType) {
        PyramidFloat ss = pyramid ? FactoryPyramid.scaleSpacePyramid((double[])scales, inputType) : FactoryPyramid.scaleSpace((double[])scales, inputType);
        return new WrapFPtoInterestPoint<T, D>(feature, ss);
    }

    public static <T extends ImageSingleBand> InterestPointDetector<T> fastHessian(ConfigFastHessian config) {
        return new WrapFHtoInterestPoint(FactoryInterestPointAlgs.fastHessian(config));
    }

    public static <T extends ImageSingleBand> InterestPointDetector<T> sift(ConfigSiftScaleSpace configSS, ConfigSiftDetector configDet, Class<T> imageType) {
        if (configSS == null) {
            configSS = new ConfigSiftScaleSpace();
        }
        if (configDet == null) {
            configDet = new ConfigSiftDetector();
        }
        SiftScaleSpace scaleSpace = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        NonMaxSuppression nonmax = FactoryFeatureExtractor.nonmax(configDet.extract);
        NonMaxLimiter limiter = new NonMaxLimiter(nonmax, configDet.maxFeaturesPerScale);
        SiftDetector detector = new SiftDetector(scaleSpace, configDet.edgeR, limiter);
        return new WrapSiftDetector<T>(detector, imageType);
    }
}

