/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;

public class WrapDescribeSurf<T extends ImageSingleBand, II extends ImageSingleBand>
implements DescribeRegionPoint<T, BrightFeature> {
    DescribePointSurf<II> surf;
    II ii;
    ImageType<T> imageType;

    public WrapDescribeSurf(DescribePointSurf<II> surf, Class<T> imageType) {
        this.surf = surf;
        this.imageType = ImageType.single(imageType);
    }

    @Override
    public BrightFeature createDescription() {
        return new BrightFeature(this.surf.getDescriptionLength());
    }

    @Override
    public void setImage(T image) {
        if (this.ii != null) {
            this.ii.reshape(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
        }
        this.ii = GIntegralImageOps.transform(image, this.ii);
        this.surf.setImage(this.ii);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, BrightFeature storage) {
        this.surf.describe(x, y, orientation, radius / 2.0, storage);
        return true;
    }

    @Override
    public boolean requiresRadius() {
        return true;
    }

    @Override
    public boolean requiresOrientation() {
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.surf.getCanonicalWidth();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }
}

