/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense.impl;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.MultiSpectral;

public class DescribeDenseHogAlg_MSF32
extends DescribeDenseHogAlg<MultiSpectral<ImageFloat32>, MultiSpectral<ImageFloat32>> {
    int numBands;

    public DescribeDenseHogAlg_MSF32(int orientationBins, int widthCell, int widthBlock, int stepBlock, int numBands) {
        super(orientationBins, widthCell, widthBlock, stepBlock, ImageType.ms((int)numBands, ImageFloat32.class));
        this.numBands = numBands;
    }

    @Override
    public void computeDerivative(int pixelIndex) {
        float maxDX = 0.0f;
        float maxDY = 0.0f;
        float maxNorm = 0.0f;
        for (int i = 0; i < this.numBands; ++i) {
            float dx = ((ImageFloat32[])((MultiSpectral)this.derivX).bands)[i].data[pixelIndex];
            float dy = ((ImageFloat32[])((MultiSpectral)this.derivY).bands)[i].data[pixelIndex];
            float n = dx * dx + dy * dy;
            if (!(n > maxNorm)) continue;
            maxNorm = n;
            maxDX = dx;
            maxDY = dy;
        }
        this.pixelDX = maxDX;
        this.pixelDY = maxDY;
    }
}

