/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense.impl;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class DescribeDenseHogAlg_MSU8
extends DescribeDenseHogAlg<MultiSpectral<ImageUInt8>, MultiSpectral<ImageSInt16>> {
    int numBands;

    public DescribeDenseHogAlg_MSU8(int orientationBins, int widthCell, int widthBlock, int stepBlock, int numBands) {
        super(orientationBins, widthCell, widthBlock, stepBlock, ImageType.ms((int)numBands, ImageUInt8.class));
        this.numBands = numBands;
    }

    @Override
    public void computeDerivative(int pixelIndex) {
        float maxDX = 0.0f;
        float maxDY = 0.0f;
        float maxNorm = 0.0f;
        for (int i = 0; i < this.numBands; ++i) {
            float dx = ((ImageSInt16[])((MultiSpectral)this.derivX).bands)[i].data[pixelIndex];
            float dy = ((ImageSInt16[])((MultiSpectral)this.derivY).bands)[i].data[pixelIndex];
            float n = dx * dx + dy * dy;
            if (!(n > maxNorm)) continue;
            maxNorm = n;
            maxDX = dx;
            maxDY = dy;
        }
        this.pixelDX = maxDX;
        this.pixelDY = maxDY;
    }
}

