/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.struct.image.ImageFloat32;

public abstract class NonMaxBlockStrict
extends NonMaxBlock {
    protected NonMaxBlockStrict(boolean detectsMinimum, boolean detectsMaximum) {
        super(detectsMinimum, detectsMaximum);
    }

    protected void checkLocalMax(int x_c, int y_c, float peakVal, ImageFloat32 img) {
        int x0 = x_c - this.radius;
        int x1 = x_c + this.radius;
        int y0 = y_c - this.radius;
        int y1 = y_c + this.radius;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 >= img.width) {
            x1 = img.width - 1;
        }
        if (y1 >= img.height) {
            y1 = img.height - 1;
        }
        for (int y = y0; y <= y1; ++y) {
            int index = img.startIndex + y * img.stride + x0;
            for (int x = x0; x <= x1; ++x) {
                int n = index++;
                float v = img.data[n];
                if (!(v >= peakVal) || x == x_c && y == y_c) continue;
                return;
            }
        }
        this.localMax.add(x_c, y_c);
    }

    protected void checkLocalMin(int x_c, int y_c, float peakVal, ImageFloat32 img) {
        int x0 = x_c - this.radius;
        int x1 = x_c + this.radius;
        int y0 = y_c - this.radius;
        int y1 = y_c + this.radius;
        if (x0 < 0) {
            x0 = 0;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (x1 >= img.width) {
            x1 = img.width - 1;
        }
        if (y1 >= img.height) {
            y1 = img.height - 1;
        }
        for (int y = y0; y <= y1; ++y) {
            int index = img.startIndex + y * img.stride + x0;
            for (int x = x0; x <= x1; ++x) {
                int n = index++;
                float v = img.data[n];
                if (!(v <= peakVal) || x == x_c && y == y_c) continue;
                return;
            }
        }
        this.localMin.add(x_c, y_c);
    }

    public static class MinMax
    extends NonMaxBlockStrict {
        public MinMax() {
            super(true, true);
        }

        @Override
        protected void searchBlock(int x0, int y0, int x1, int y1, ImageFloat32 img) {
            int maxX = 0;
            int maxY = 0;
            int minX = 0;
            int minY = 0;
            float maxVal = -3.4028235E38f;
            float minVal = Float.MAX_VALUE;
            for (int y = y0; y < y1; ++y) {
                int index = img.startIndex + y * img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = img.data[n];
                    if (v > maxVal) {
                        maxVal = v;
                        maxX = x;
                        maxY = y;
                    }
                    if (!(v < minVal)) continue;
                    minVal = v;
                    minX = x;
                    minY = y;
                }
            }
            if (maxVal >= this.thresholdMax && maxVal != Float.MAX_VALUE) {
                this.checkLocalMax(maxX, maxY, maxVal, img);
            }
            if (minVal <= this.thresholdMin && minVal != -3.4028235E38f) {
                this.checkLocalMin(minX, minY, minVal, img);
            }
        }
    }

    public static class Min
    extends NonMaxBlockStrict {
        public Min() {
            super(true, false);
        }

        @Override
        protected void searchBlock(int x0, int y0, int x1, int y1, ImageFloat32 img) {
            int peakX = 0;
            int peakY = 0;
            float peakVal = Float.MAX_VALUE;
            for (int y = y0; y < y1; ++y) {
                int index = img.startIndex + y * img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = img.data[n];
                    if (!(v < peakVal)) continue;
                    peakVal = v;
                    peakX = x;
                    peakY = y;
                }
            }
            if (peakVal <= this.thresholdMin && peakVal != -3.4028235E38f) {
                this.checkLocalMin(peakX, peakY, peakVal, img);
            }
        }
    }

    public static class Max
    extends NonMaxBlockStrict {
        public Max() {
            super(false, true);
        }

        @Override
        protected void searchBlock(int x0, int y0, int x1, int y1, ImageFloat32 img) {
            int peakX = 0;
            int peakY = 0;
            float peakVal = -3.4028235E38f;
            for (int y = y0; y < y1; ++y) {
                int index = img.startIndex + y * img.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    int n = index++;
                    float v = img.data[n];
                    if (!(v > peakVal)) continue;
                    peakVal = v;
                    peakX = x;
                    peakY = y;
                }
            }
            if (peakVal >= this.thresholdMax && peakVal != Float.MAX_VALUE) {
                this.checkLocalMax(peakX, peakY, peakVal, img);
            }
        }
    }
}

