/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.filter.convolve.ConvolveNormalized;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;

public abstract class ImplSsdCornerWeighted_F32
implements GradientCornerIntensity<ImageFloat32> {
    int radius;
    Kernel1D_F32 kernel;
    ImageFloat32 imgXX = new ImageFloat32(1, 1);
    ImageFloat32 imgYY = new ImageFloat32(1, 1);
    ImageFloat32 imgXY = new ImageFloat32(1, 1);
    ImageFloat32 temp = new ImageFloat32(1, 1);
    protected float totalXX;
    protected float totalYY;
    protected float totalXY;

    public ImplSsdCornerWeighted_F32(int radius) {
        this.radius = radius;
        this.kernel = (Kernel1D_F32)FactoryKernelGaussian.gaussian(Kernel1D_F32.class, (double)-1.0, (int)radius);
    }

    @Override
    public void process(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 intensity) {
        int y;
        InputSanityCheck.checkSameShape((ImageBase)derivX, (ImageBase)derivY, (ImageBase)intensity);
        int w = derivX.width;
        int h = derivX.height;
        this.imgXX.reshape(w, h);
        this.imgYY.reshape(w, h);
        this.imgXY.reshape(w, h);
        this.temp.reshape(w, h);
        intensity.reshape(w, h);
        int index = 0;
        for (y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + derivX.stride * y;
            int indexY = derivY.startIndex + derivY.stride * y;
            int x = 0;
            while (x < w) {
                float dx = derivX.data[indexX++];
                float dy = derivY.data[indexY++];
                this.imgXX.data[index] = dx * dx;
                this.imgYY.data[index] = dy * dy;
                this.imgXY.data[index] = dx * dy;
                ++x;
                ++index;
            }
        }
        this.blur(this.imgXX, this.temp);
        this.blur(this.imgYY, this.temp);
        this.blur(this.imgXY, this.temp);
        index = 0;
        for (y = 0; y < h; ++y) {
            int x = 0;
            while (x < w) {
                this.totalXX = this.imgXX.data[index];
                this.totalYY = this.imgYY.data[index];
                this.totalXY = this.imgXY.data[index];
                intensity.data[index] = this.computeResponse();
                ++x;
                ++index;
            }
        }
    }

    protected abstract float computeResponse();

    private void blur(ImageFloat32 image, ImageFloat32 temp) {
        ConvolveNormalized.horizontal((Kernel1D_F32)this.kernel, (ImageFloat32)image, (ImageFloat32)temp);
        ConvolveNormalized.vertical((Kernel1D_F32)this.kernel, (ImageFloat32)temp, (ImageFloat32)image);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    @Override
    public int getIgnoreBorder() {
        return 0;
    }
}

