/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.alg.filter.convolve.GConvolveImageOps;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public class SiftScaleSpace {
    ImageFloat32[] octaveImages;
    ImageFloat32[] differenceOfGaussian;
    double sigma0;
    int firstOctave;
    int lastOctave;
    int numScales;
    double levelK;
    Kernel1D_F32 kernelSigma0;
    Kernel1D_F32[] kernelSigmaToK;
    ImageFloat32 input;
    int currentOctave;
    ImageFloat32 tempBlur;
    ImageFloat32 tempImage0;
    ImageFloat32 tempImage1;
    InterpolatePixelS<ImageFloat32> interp = FactoryInterpolation.bilinearPixelS(ImageFloat32.class, (BorderType)BorderType.EXTENDED);

    public SiftScaleSpace(int firstOctave, int lastOctave, int numScales, double sigma0) {
        if (lastOctave <= firstOctave) {
            throw new IllegalArgumentException("Last octave must be more than the first octave");
        }
        if (numScales < 1) {
            throw new IllegalArgumentException("Number of scales must be >= 1");
        }
        this.firstOctave = firstOctave;
        this.lastOctave = lastOctave;
        this.numScales = numScales;
        this.sigma0 = sigma0;
        this.octaveImages = new ImageFloat32[numScales + 3];
        this.differenceOfGaussian = new ImageFloat32[numScales + 2];
        for (int i = 1; i < this.octaveImages.length; ++i) {
            this.octaveImages[i] = new ImageFloat32(1, 1);
            this.differenceOfGaussian[i - 1] = new ImageFloat32(1, 1);
        }
        this.tempImage0 = new ImageFloat32(1, 1);
        this.tempImage1 = new ImageFloat32(1, 1);
        this.tempBlur = new ImageFloat32(1, 1);
        this.levelK = Math.pow(2.0, 1.0 / (double)numScales);
        Class kernelType = FactoryKernel.getKernelType(ImageFloat32.class, (int)1);
        this.kernelSigma0 = (Kernel1D_F32)FactoryKernelGaussian.gaussian((Class)kernelType, (double)sigma0, (int)-1);
        this.kernelSigmaToK = new Kernel1D_F32[numScales + 2];
        for (int i = 1; i < numScales + 3; ++i) {
            double before = this.computeSigmaScale(0, i - 1);
            double sigma = before * Math.sqrt(this.levelK - 1.0);
            this.kernelSigmaToK[i - 1] = (Kernel1D_F32)FactoryKernelGaussian.gaussian((Class)kernelType, (double)sigma, (int)-1);
        }
    }

    public double computeSigmaScale(int scale) {
        return this.computeSigmaScale(this.currentOctave, scale);
    }

    public double computeSigmaScale(int octave, int scale) {
        return this.sigma0 * Math.pow(2.0, (double)octave + (double)scale / (double)this.numScales);
    }

    public void initialize(ImageFloat32 input) {
        this.input = input;
        this.currentOctave = this.firstOctave;
        if (this.firstOctave < 0) {
            PyramidOps.scaleImageUp((ImageSingleBand)input, (ImageSingleBand)this.tempImage1, (int)(-2 * this.firstOctave), this.interp);
            this.tempImage0.reshape(this.tempImage1.width, this.tempImage1.height);
            this.applyGaussian(this.tempImage1, this.tempImage0, (Kernel1D)this.kernelSigma0);
        } else {
            this.tempImage0.reshape(input.width, input.height);
            this.applyGaussian(input, this.tempImage0, (Kernel1D)this.kernelSigma0);
            for (int i = 0; i < this.firstOctave; ++i) {
                this.tempImage1.reshape(this.tempImage0.width, this.tempImage0.height);
                this.applyGaussian(this.tempImage0, this.tempImage1, (Kernel1D)this.kernelSigma0);
                PyramidOps.scaleDown2((ImageSingleBand)this.tempImage1, (ImageSingleBand)this.tempImage0);
            }
        }
        this.computeOctaveScales();
    }

    public boolean computeNextOctave() {
        ++this.currentOctave;
        if (this.currentOctave > this.lastOctave) {
            return false;
        }
        if (this.octaveImages[this.numScales].width <= 5 || this.octaveImages[this.numScales].height <= 5) {
            return false;
        }
        PyramidOps.scaleDown2((ImageSingleBand)this.octaveImages[this.numScales], (ImageSingleBand)this.tempImage0);
        this.computeOctaveScales();
        return true;
    }

    private void computeOctaveScales() {
        int i;
        this.octaveImages[0] = this.tempImage0;
        for (i = 1; i < this.numScales + 3; ++i) {
            this.octaveImages[i].reshape(this.tempImage0.width, this.tempImage0.height);
            this.applyGaussian(this.octaveImages[i - 1], this.octaveImages[i], (Kernel1D)this.kernelSigmaToK[i - 1]);
        }
        for (i = 1; i < this.numScales + 3; ++i) {
            this.differenceOfGaussian[i - 1].reshape(this.tempImage0.width, this.tempImage0.height);
            PixelMath.subtract((ImageFloat32)this.octaveImages[i], (ImageFloat32)this.octaveImages[i - 1], (ImageFloat32)this.differenceOfGaussian[i - 1]);
        }
    }

    public ImageFloat32 getImageScale(int scaleIndex) {
        return this.octaveImages[scaleIndex];
    }

    public ImageFloat32 getDifferenceOfGaussian(int dogIndex) {
        return this.differenceOfGaussian[dogIndex];
    }

    void applyGaussian(ImageFloat32 input, ImageFloat32 output, Kernel1D kernel) {
        this.tempBlur.reshape(input.width, input.height);
        GConvolveImageOps.horizontalNormalized((Kernel1D)kernel, (ImageSingleBand)input, (ImageSingleBand)this.tempBlur);
        GConvolveImageOps.verticalNormalized((Kernel1D)kernel, (ImageSingleBand)this.tempBlur, (ImageSingleBand)output);
    }

    public int getNumScales() {
        return this.numScales;
    }

    public int getNumScaleImages() {
        return this.numScales + 3;
    }

    public int getCurrentOctave() {
        return this.currentOctave;
    }

    public int getTotalOctaves() {
        return this.lastOctave - this.firstOctave + 1;
    }

    public double pixelScaleCurrentToInput() {
        return Math.pow(2.0, this.currentOctave);
    }
}

