/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageSingleBand;

public abstract class OrientationImageAverage<T extends ImageSingleBand>
implements OrientationImage<T> {
    protected T image;
    protected ImageRectangle rect = new ImageRectangle();
    protected double objectToSample;
    protected int sampleRadius;
    protected Kernel2D_F32 kerCosine;
    protected Kernel2D_F32 kerSine;

    public OrientationImageAverage(double objectToSample, int defaultRadius) {
        this.objectToSample = objectToSample;
        this.setObjectRadius(defaultRadius);
    }

    @Override
    public void setImage(T image) {
        this.image = image;
    }

    @Override
    public void setObjectRadius(double objectRadius) {
        this.sampleRadius = (int)Math.ceil(objectRadius * this.objectToSample);
        int w = this.sampleRadius * 2 + 1;
        this.kerCosine = new Kernel2D_F32(w);
        this.kerSine = new Kernel2D_F32(w);
        for (int y = -this.sampleRadius; y <= this.sampleRadius; ++y) {
            int pixelY = y + this.sampleRadius;
            for (int x = -this.sampleRadius; x <= this.sampleRadius; ++x) {
                int pixelX = x + this.sampleRadius;
                float r = (float)Math.sqrt(x * x + y * y);
                this.kerCosine.set(pixelX, pixelY, (float)x / r);
                this.kerSine.set(pixelX, pixelY, (float)y / r);
            }
        }
        this.kerCosine.set(this.sampleRadius, this.sampleRadius, 0.0f);
        this.kerSine.set(this.sampleRadius, this.sampleRadius, 0.0f);
    }

    @Override
    public double compute(double X, double Y) {
        int c_x = (int)(X + 0.5);
        int c_y = (int)(Y + 0.5);
        this.rect.x0 = c_x - this.sampleRadius;
        this.rect.y0 = c_y - this.sampleRadius;
        this.rect.x1 = c_x + this.sampleRadius + 1;
        this.rect.y1 = c_y + this.sampleRadius + 1;
        BoofMiscOps.boundRectangleInside(this.image, (ImageRectangle)this.rect);
        return this.computeAngle(c_x, c_y);
    }

    protected abstract double computeAngle(int var1, int var2);
}

