/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationAverage;
import boofcv.struct.image.ImageSInt16;

public class ImplOrientationAverage_S16
extends OrientationAverage<ImageSInt16> {
    public ImplOrientationAverage_S16(double objectToSample, boolean weighted) {
        super(objectToSample, weighted);
    }

    @Override
    public Class<ImageSInt16> getImageType() {
        return ImageSInt16.class;
    }

    @Override
    protected double computeUnweightedScore() {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((ImageSInt16)this.derivX).startIndex + ((ImageSInt16)this.derivX).stride * y + this.rect.x0;
            int indexY = ((ImageSInt16)this.derivY).startIndex + ((ImageSInt16)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                sumX += (float)((ImageSInt16)this.derivX).data[indexX];
                sumY += (float)((ImageSInt16)this.derivY).data[indexY];
                ++x;
                ++indexX;
                ++indexY;
            }
        }
        return Math.atan2(sumY, sumX);
    }

    @Override
    protected double computeWeightedScore(int c_x, int c_y) {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((ImageSInt16)this.derivX).startIndex + ((ImageSInt16)this.derivX).stride * y + this.rect.x0;
            int indexY = ((ImageSInt16)this.derivY).startIndex + ((ImageSInt16)this.derivY).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.radiusScale) * this.weights.width + this.rect.x0 - c_x + this.radiusScale;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                float w = this.weights.data[indexW];
                sumX += w * (float)((ImageSInt16)this.derivX).data[indexX];
                sumY += w * (float)((ImageSInt16)this.derivY).data[indexY];
                ++x;
                ++indexX;
                ++indexY;
                ++indexW;
            }
        }
        return Math.atan2(sumY, sumX);
    }
}

