/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationIntegralBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.GradientValue;
import georegression.metric.UtilAngle;
import org.ddogleg.sorting.QuickSort_F64;

public class ImplOrientationSlidingWindowIntegral<T extends ImageSingleBand, G extends GradientValue>
extends OrientationIntegralBase<T, G> {
    double[] derivX;
    double[] derivY;
    protected double windowSize;
    protected double[] angles;
    protected int[] order;
    int total = 0;
    QuickSort_F64 sorter = new QuickSort_F64();

    public ImplOrientationSlidingWindowIntegral(double radiusToScale, double samplePeriod, double windowSize, int sampleRadius, double weightSigma, int sampleKernelWidth, Class<T> integralType) {
        super(radiusToScale, sampleRadius, samplePeriod, sampleKernelWidth, weightSigma, integralType);
        this.windowSize = windowSize;
        this.derivX = new double[this.sampleWidth * this.sampleWidth];
        this.derivY = new double[this.sampleWidth * this.sampleWidth];
        this.angles = new double[this.sampleWidth * this.sampleWidth];
        this.order = new int[this.angles.length];
    }

    @Override
    public double compute(double c_x, double c_y) {
        int i;
        double period = this.scale * this.period;
        double tl_x = c_x - (double)this.sampleRadius * period;
        double tl_y = c_y - (double)this.sampleRadius * period;
        this.computeGradient(tl_x, tl_y, period);
        if (this.weights != null) {
            i = 0;
            while (i < this.total) {
                double w = this.weights.data[i];
                int n = i;
                this.derivX[n] = this.derivX[n] * w;
                int n2 = i++;
                this.derivY[n2] = this.derivY[n2] * w;
            }
        }
        for (i = 0; i < this.total; ++i) {
            this.angles[i] = Math.atan2(this.derivY[i], this.derivX[i]);
        }
        this.sorter.sort(this.angles, this.angles.length, this.order);
        return this.estimateAngle();
    }

    private void computeGradient(double tl_x, double tl_y, double samplePeriod) {
        tl_x += 0.5;
        tl_y += 0.5;
        this.total = 0;
        for (int y = 0; y < this.sampleWidth; ++y) {
            int x = 0;
            while (x < this.sampleWidth) {
                int xx = (int)(tl_x + (double)x * samplePeriod);
                int yy = (int)(tl_y + (double)y * samplePeriod);
                if (this.g.isInBounds(xx, yy)) {
                    GradientValue deriv = this.g.compute(xx, yy);
                    double dx = deriv.getX();
                    double dy = deriv.getY();
                    this.derivX[this.total] = dx;
                    this.derivY[this.total] = dy;
                } else {
                    this.derivX[this.total] = 0.0;
                    this.derivY[this.total] = 0.0;
                }
                ++x;
                ++this.total;
            }
        }
    }

    private double estimateAngle() {
        int start;
        int end = 1;
        int startIndex = this.order[start];
        int endIndex = this.order[end];
        double sumX = this.derivX[startIndex];
        double sumY = this.derivY[startIndex];
        double best = sumX * sumX + sumY * sumY;
        double bestX = sumX;
        double bestY = sumY;
        double endAngle = this.angles[endIndex];
        for (start = 0; start != this.total; ++start) {
            startIndex = this.order[start];
            double startAngle = this.angles[startIndex];
            while (UtilAngle.dist((double)startAngle, (double)endAngle) <= this.windowSize) {
                double mag;
                if ((mag = (sumX += this.derivX[endIndex]) * sumX + (sumY += this.derivY[endIndex]) * sumY) > best) {
                    best = mag;
                    bestX = sumX;
                    bestY = sumY;
                }
                if (++end >= this.total) {
                    end = 0;
                }
                endIndex = this.order[end];
                endAngle = this.angles[endIndex];
                if (endIndex != startIndex) continue;
                break;
            }
            sumX -= this.derivX[startIndex];
            sumY -= this.derivY[startIndex];
        }
        return Math.atan2(bestY, bestX);
    }
}

