/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationSlidingWindow;
import boofcv.struct.image.ImageSInt32;
import georegression.metric.UtilAngle;

public class ImplOrientationSlidingWindow_S32
extends OrientationSlidingWindow<ImageSInt32> {
    public ImplOrientationSlidingWindow_S32(double objectRadiusToScale, int numAngles, double windowSize, boolean isWeighted) {
        super(objectRadiusToScale, numAngles, windowSize, isWeighted);
    }

    @Override
    public Class<ImageSInt32> getImageType() {
        return ImageSInt32.class;
    }

    private void computeAngles() {
        int i = 0;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((ImageSInt32)this.derivX).startIndex + ((ImageSInt32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((ImageSInt32)this.derivY).startIndex + ((ImageSInt32)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int dx = ((ImageSInt32)this.derivX).data[indexX];
                int dy = ((ImageSInt32)this.derivY).data[indexY];
                this.angles[i++] = Math.atan2(dy, dx);
                ++x;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected double computeOrientation() {
        this.computeAngles();
        double windowRadius = this.windowSize / 2.0;
        int w = this.rect.x1 - this.rect.x0;
        double bestScore = -1.0;
        double bestAngle = 0.0;
        double stepAngle = Math.PI * 2 / (double)this.numAngles;
        int N = w * (this.rect.y1 - this.rect.y0);
        for (double angle = -Math.PI; angle < Math.PI; angle += stepAngle) {
            double dx = 0.0;
            double dy = 0.0;
            for (int i = 0; i < N; ++i) {
                double diff = UtilAngle.dist((double)angle, (double)this.angles[i]);
                if (!(diff <= windowRadius)) continue;
                int x = this.rect.x0 + i % w;
                int y = this.rect.y0 + i / w;
                dx += (double)((ImageSInt32)this.derivX).get(x, y);
                dy += (double)((ImageSInt32)this.derivY).get(x, y);
            }
            double n = dx * dx + dy * dy;
            if (!(n > bestScore)) continue;
            bestAngle = Math.atan2(dy, dx);
            bestScore = n;
        }
        return bestAngle;
    }

    @Override
    protected double computeWeightedOrientation(int c_x, int c_y) {
        this.computeAngles();
        double windowRadius = this.windowSize / 2.0;
        int w = this.rect.x1 - this.rect.x0;
        double bestScore = -1.0;
        double bestAngle = 0.0;
        double stepAngle = Math.PI * 2 / (double)this.numAngles;
        int N = w * (this.rect.y1 - this.rect.y0);
        for (double angle = -Math.PI; angle < Math.PI; angle += stepAngle) {
            double dx = 0.0;
            double dy = 0.0;
            for (int i = 0; i < N; ++i) {
                double diff = UtilAngle.dist((double)angle, (double)this.angles[i]);
                if (!(diff <= windowRadius)) continue;
                int localX = i % w;
                int localY = i / w;
                double ww = this.weights.get(localX, localY);
                int x = this.rect.x0 + i % w;
                int y = this.rect.y0 + i / w;
                dx += ww * (double)((ImageSInt32)this.derivX).get(x, y);
                dy += ww * (double)((ImageSInt32)this.derivY).get(x, y);
            }
            double n = dx * dx + dy * dy;
            if (!(n > bestScore)) continue;
            bestAngle = Math.atan2(dy, dx);
            bestScore = n;
        }
        return bestAngle;
    }
}

