/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.polygon;

import boofcv.alg.shapes.corner.RefineCornerLinesToImage;
import boofcv.alg.shapes.edge.SnapToEdge;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.misc.CircularIndex;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;
import org.ddogleg.struct.GrowQueue_I32;

public class RefinePolygonCornersToImage<T extends ImageSingleBand>
implements RefineBinaryPolygon<T> {
    private int pixelsAway;
    protected RefineCornerLinesToImage<T> refineCorner;
    protected Point2D_F64 cornerPt = new Point2D_F64();
    protected Point2D_F64 leftPt = new Point2D_F64();
    protected Point2D_F64 rightPt = new Point2D_F64();
    protected List<Point2D_I32> contour;
    protected GrowQueue_I32 splits;

    public RefinePolygonCornersToImage(int endPointDistance, double cornerOffset, int maxLineSamples, int sampleRadius, int maxIterations, double convergeTolPixels, double maxCornerChangePixels, Class<T> imageType) {
        this.pixelsAway = endPointDistance;
        this.refineCorner = new RefineCornerLinesToImage<T>(cornerOffset, maxLineSamples, sampleRadius, maxIterations, convergeTolPixels, maxCornerChangePixels, imageType);
    }

    public RefinePolygonCornersToImage(Class<T> imageType) {
        this(12, 2.0, 10, 1, 10, 1.0E-6, 2.0, imageType);
    }

    @Override
    public void setImage(T input) {
        this.refineCorner.setImage(input);
    }

    @Override
    public void setLensDistortion(int width, int height, PixelTransform_F32 distToUndist, PixelTransform_F32 undistToDist) {
        this.refineCorner.getSnapToEdge().setTransform(undistToDist);
    }

    @Override
    public boolean refine(Polygon2D_F64 input, List<Point2D_I32> contour, GrowQueue_I32 splits, Polygon2D_F64 refined) {
        if (refined.size() != splits.size()) {
            throw new IllegalArgumentException("Miss match between number of splits and polygon order");
        }
        this.contour = contour;
        this.splits = splits;
        int numGood = 0;
        for (int cornerS = 0; cornerS < splits.size(); ++cornerS) {
            int indexLeft = this.pickEndIndex(cornerS, 1);
            int indexRight = this.pickEndIndex(cornerS, -1);
            Point2D_I32 contourCorner = contour.get(splits.get(cornerS));
            Point2D_I32 contourLeft = contour.get(indexLeft);
            Point2D_I32 contourRight = contour.get(indexRight);
            this.cornerPt.set((double)contourCorner.x, (double)contourCorner.y);
            this.leftPt.set((double)contourLeft.x, (double)contourLeft.y);
            this.rightPt.set((double)contourRight.x, (double)contourRight.y);
            if (this.refineCorner.refine(this.cornerPt, this.leftPt, this.rightPt)) {
                refined.get(cornerS).set(this.refineCorner.getRefinedCorner());
                ++numGood;
                continue;
            }
            refined.get(cornerS).set(this.cornerPt);
        }
        return numGood >= refined.size() - 1;
    }

    protected int pickEndIndex(int cornerS, int dir) {
        int dist1;
        int cornerIndex = this.splits.get(cornerS);
        int endIndex0 = this.splits.get(CircularIndex.addOffset((int)cornerS, (int)dir, (int)this.splits.size));
        int endIndex1 = this.splits.get(CircularIndex.addOffset((int)cornerS, (int)(-dir), (int)this.splits.size));
        int dist0 = CircularIndex.distanceP((int)cornerIndex, (int)endIndex0, (int)this.contour.size());
        if (dir == 1 != (dist1 = CircularIndex.distanceP((int)cornerIndex, (int)endIndex1, (int)this.contour.size())) > dist0) {
            dir = -dir;
        }
        if (dir < 0) {
            int distance = CircularIndex.distanceP((int)endIndex0, (int)cornerIndex, (int)this.contour.size());
            distance = Math.min(distance, this.pixelsAway);
            return CircularIndex.addOffset((int)cornerIndex, (int)(-distance), (int)this.contour.size());
        }
        int distance = CircularIndex.distanceP((int)cornerIndex, (int)endIndex0, (int)this.contour.size());
        distance = Math.min(distance, this.pixelsAway);
        return CircularIndex.addOffset((int)cornerIndex, (int)distance, (int)this.contour.size());
    }

    public int getPixelsAway() {
        return this.pixelsAway;
    }

    public void setPixelsAway(int pixelsAway) {
        this.pixelsAway = pixelsAway;
    }

    public SnapToEdge<T> getSnapToEdge() {
        return this.refineCorner.getSnapToEdge();
    }
}

