/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateNearestNeighbor;
import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq_F32;
import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq_F64;
import boofcv.abst.feature.associate.ScoreAssociateEuclidean_F64;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociateSad_F32;
import boofcv.abst.feature.associate.ScoreAssociateSad_F64;
import boofcv.abst.feature.associate.ScoreAssociateSad_S8;
import boofcv.abst.feature.associate.ScoreAssociateSad_U8;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.associate.WrapAssociateGreedy;
import boofcv.alg.feature.associate.AssociateGreedy;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;

public class FactoryAssociation {
    public static <D> AssociateDescription<D> greedy(ScoreAssociation<D> score, double maxError, boolean backwardsValidation) {
        AssociateGreedy<D> alg = new AssociateGreedy<D>(score, backwardsValidation);
        alg.setMaxFitError(maxError);
        WrapAssociateGreedy<D> ret = new WrapAssociateGreedy<D>(alg);
        return ret;
    }

    public static AssociateDescription<TupleDesc_F64> kdtree(int dimension, int maxNodesSearched) {
        NearestNeighbor nn = FactoryNearestNeighbor.kdtree((int)maxNodesSearched);
        return new AssociateNearestNeighbor<TupleDesc_F64>((NearestNeighbor<Integer>)nn, dimension);
    }

    public static AssociateDescription<TupleDesc_F64> kdRandomForest(int dimension, int maxNodesSearched, int numTrees, int numConsiderSplit, long randomSeed) {
        NearestNeighbor nn = FactoryNearestNeighbor.kdRandomForest((int)maxNodesSearched, (int)numTrees, (int)numConsiderSplit, (long)randomSeed);
        return new AssociateNearestNeighbor<TupleDesc_F64>((NearestNeighbor<Integer>)nn, dimension);
    }

    public static <D> ScoreAssociation<D> defaultScore(Class<D> tupleType) {
        if (NccFeature.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateNccFeature();
        }
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateEuclideanSq_F64();
        }
        if (tupleType == TupleDesc_F32.class) {
            return new ScoreAssociateEuclideanSq_F32();
        }
        if (tupleType == TupleDesc_U8.class) {
            return new ScoreAssociateSad_U8();
        }
        if (tupleType == TupleDesc_B.class) {
            return new ScoreAssociateHamming_B();
        }
        throw new IllegalArgumentException("Unknown tuple type: " + tupleType);
    }

    public static <D> ScoreAssociation<D> scoreSad(Class<D> tupleType) {
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateSad_F64();
        }
        if (tupleType == TupleDesc_F32.class) {
            return new ScoreAssociateSad_F32();
        }
        if (tupleType == TupleDesc_U8.class) {
            return new ScoreAssociateSad_U8();
        }
        if (tupleType == TupleDesc_S8.class) {
            return new ScoreAssociateSad_S8();
        }
        throw new IllegalArgumentException("SAD score not supported for type " + tupleType.getSimpleName());
    }

    public static ScoreAssociation<NccFeature> scoreNcc() {
        return new ScoreAssociateNccFeature();
    }

    public static <D> ScoreAssociation<D> scoreEuclidean(Class<D> tupleType, boolean squared) {
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            if (squared) {
                return new ScoreAssociateEuclideanSq_F64();
            }
            return new ScoreAssociateEuclidean_F64();
        }
        if (tupleType == TupleDesc_F32.class && squared) {
            return new ScoreAssociateEuclideanSq_F32();
        }
        throw new IllegalArgumentException("Euclidean score not yet supported for type " + tupleType.getSimpleName());
    }

    public static <D> ScoreAssociation<D> scoreHamming(Class<D> tupleType) {
        if (tupleType == TupleDesc_B.class) {
            return new ScoreAssociateHamming_B();
        }
        throw new IllegalArgumentException("Hamming distance not yet supported for type " + tupleType.getSimpleName());
    }
}

