/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.abst.feature.dense.DescribeImageDenseHoG;
import boofcv.abst.feature.dense.DescribeImageDenseSift;
import boofcv.abst.feature.dense.GenericDenseDescribeImageDense;
import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.alg.feature.dense.DescribeDenseSiftAlg;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_F32;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_MSF32;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_MSU8;
import boofcv.alg.feature.dense.impl.DescribeDenseHogAlg_U8;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.dense.ConfigDenseHoG;
import boofcv.factory.feature.dense.ConfigDenseSift;
import boofcv.factory.feature.dense.ConfigDenseSurfFast;
import boofcv.factory.feature.dense.ConfigDenseSurfStable;
import boofcv.factory.feature.describe.FactoryDescribeRegionPoint;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;

public class FactoryDescribeImageDense {
    public static <T extends ImageSingleBand, II extends ImageSingleBand> DescribeImageDense<T, TupleDesc_F64> surfFast(ConfigDenseSurfFast configSurf, Class<T> imageType) {
        configSurf.checkValidity();
        DescribeRegionPoint<T, BrightFeature> surf = FactoryDescribeRegionPoint.surfFast(configSurf.surf, imageType);
        return new GenericDenseDescribeImageDense<T, BrightFeature>(surf, 2.0, configSurf.descriptorScale, configSurf.sampling.periodX, configSurf.sampling.periodY);
    }

    public static <T extends ImageSingleBand, II extends ImageSingleBand> DescribeImageDense<T, TupleDesc_F64> surfStable(ConfigDenseSurfStable configSurf, Class<T> imageType) {
        configSurf.checkValidity();
        DescribeRegionPoint<T, BrightFeature> surf = FactoryDescribeRegionPoint.surfStable(configSurf.surf, imageType);
        return new GenericDenseDescribeImageDense<T, BrightFeature>(surf, 2.0, configSurf.descriptorScale, configSurf.sampling.periodX, configSurf.sampling.periodY);
    }

    public static <T extends ImageSingleBand> DescribeImageDense<T, TupleDesc_F64> sift(ConfigDenseSift config, Class<T> imageType) {
        config.checkValidity();
        ConfigSiftDescribe c = config.sift;
        Class derivType = GImageDerivativeOps.getDerivativeType(imageType);
        DescribeDenseSiftAlg alg = new DescribeDenseSiftAlg(c.widthSubregion, c.widthGrid, c.numHistogramBins, c.weightingSigmaFraction, c.maxDescriptorElementValue, 1.0, 1.0, derivType);
        return new DescribeImageDenseSift(alg, config.sampling.periodX, config.sampling.periodY, imageType);
    }

    public static <T extends ImageBase> DescribeImageDense<T, TupleDesc_F64> hog(ConfigDenseHoG config, ImageType<T> imageType) {
        DescribeDenseHogAlg hog;
        block9: {
            block10: {
                block8: {
                    config.checkValidity();
                    if (imageType.getFamily() != ImageType.Family.SINGLE_BAND) break block8;
                    switch (imageType.getDataType()) {
                        case U8: {
                            hog = new DescribeDenseHogAlg_U8(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock);
                            break block9;
                        }
                        case F32: {
                            hog = new DescribeDenseHogAlg_F32(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported image type");
                        }
                    }
                }
                if (imageType.getFamily() != ImageType.Family.MULTI_SPECTRAL) break block10;
                switch (imageType.getDataType()) {
                    case U8: {
                        hog = new DescribeDenseHogAlg_MSU8(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock, imageType.getNumBands());
                        break block9;
                    }
                    case F32: {
                        hog = new DescribeDenseHogAlg_MSF32(config.orientationBins, config.widthCell, config.widthBlock, config.stepBlock, imageType.getNumBands());
                        break block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported image type");
                    }
                }
            }
            throw new IllegalArgumentException("Unsupported image type");
        }
        return new DescribeImageDenseHoG<ImageUInt8>(hog);
    }
}

