/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detdesc;

import boofcv.abst.feature.describe.ConfigSiftDescribe;
import boofcv.abst.feature.describe.ConfigSiftScaleSpace;
import boofcv.abst.feature.describe.ConfigSurfDescribe;
import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.ConfigCompleteSift;
import boofcv.abst.feature.detdesc.DetectDescribeFusion;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detdesc.DetectDescribe_CompleteSift;
import boofcv.abst.feature.detdesc.SurfMultiSpectral_to_DetectDescribePoint;
import boofcv.abst.feature.detdesc.WrapDetectDescribeSurf;
import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigSiftDetector;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSiftOrientation;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.DescribePointSurfMod;
import boofcv.alg.feature.describe.DescribePointSurfMultiSpectral;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.alg.feature.detdesc.DetectDescribeSurfMultiSpectral;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.factory.feature.describe.FactoryDescribePointAlgs;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.interest.FactoryInterestPointAlgs;
import boofcv.factory.feature.orientation.FactoryOrientationAlgs;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;

public class FactoryDetectDescribe {
    public static <T extends ImageSingleBand> DetectDescribePoint<T, BrightFeature> sift(ConfigCompleteSift config) {
        if (config == null) {
            config = new ConfigCompleteSift();
        }
        ConfigSiftScaleSpace configSS = config.scaleSpace;
        ConfigSiftDetector configDetector = config.detector;
        ConfigSiftOrientation configOri = config.orientation;
        ConfigSiftDescribe configDesc = config.describe;
        SiftScaleSpace scaleSpace = new SiftScaleSpace(configSS.firstOctave, configSS.lastOctave, configSS.numScales, configSS.sigma0);
        OrientationHistogramSift<ImageFloat32> orientation = new OrientationHistogramSift<ImageFloat32>(configOri.histogramSize, configOri.sigmaEnlarge, ImageFloat32.class);
        DescribePointSift<ImageFloat32> describe = new DescribePointSift<ImageFloat32>(configDesc.widthSubregion, configDesc.widthGrid, configDesc.numHistogramBins, configDesc.sigmaToPixels, configDesc.weightingSigmaFraction, configDesc.maxDescriptorElementValue, ImageFloat32.class);
        NonMaxSuppression nns = FactoryFeatureExtractor.nonmax(configDetector.extract);
        NonMaxLimiter nonMax = new NonMaxLimiter(nns, configDetector.maxFeaturesPerScale);
        CompleteSift dds = new CompleteSift(scaleSpace, configDetector.edgeR, nonMax, orientation, describe);
        return new DetectDescribe_CompleteSift(dds);
    }

    public static <T extends ImageSingleBand, II extends ImageSingleBand> DetectDescribePoint<T, BrightFeature> surfFast(ConfigFastHessian configDetector, ConfigSurfDescribe.Speed configDesc, ConfigAverageIntegral configOrientation, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurf describe = FactoryDescribePointAlgs.surfSpeed(configDesc, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.average_ii(configOrientation, integralType);
        return new WrapDetectDescribeSurf(detector, orientation, describe);
    }

    public static <T extends ImageSingleBand, II extends ImageSingleBand> DetectDescribePoint<T, BrightFeature> surfColorFast(ConfigFastHessian configDetector, ConfigSurfDescribe.Speed configDesc, ConfigAverageIntegral configOrientation, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurf describe = FactoryDescribePointAlgs.surfSpeed(configDesc, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.average_ii(configOrientation, integralType);
        if (imageType.getFamily() == ImageType.Family.MULTI_SPECTRAL) {
            DescribePointSurfMultiSpectral describeMulti = new DescribePointSurfMultiSpectral(describe, imageType.getNumBands());
            DetectDescribeSurfMultiSpectral deteDesc = new DetectDescribeSurfMultiSpectral(detector, orientation, describeMulti);
            return new SurfMultiSpectral_to_DetectDescribePoint(deteDesc, bandType, integralType);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    public static <T extends ImageSingleBand, II extends ImageSingleBand> DetectDescribePoint<T, BrightFeature> surfStable(ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, Class<T> imageType) {
        Class integralType = GIntegralImageOps.getIntegralType(imageType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurfMod describe = FactoryDescribePointAlgs.surfStability(configDescribe, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
        return new WrapDetectDescribeSurf(detector, orientation, describe);
    }

    public static <T extends ImageMultiBand, II extends ImageSingleBand> DetectDescribePoint<T, BrightFeature> surfColorStable(ConfigFastHessian configDetector, ConfigSurfDescribe.Stability configDescribe, ConfigSlidingIntegral configOrientation, ImageType<T> imageType) {
        Class bandType = imageType.getImageClass();
        Class integralType = GIntegralImageOps.getIntegralType((Class)bandType);
        FastHessianFeatureDetector detector = FactoryInterestPointAlgs.fastHessian(configDetector);
        DescribePointSurfMod describe = FactoryDescribePointAlgs.surfStability(configDescribe, integralType);
        OrientationIntegral orientation = FactoryOrientationAlgs.sliding_ii(configOrientation, integralType);
        if (imageType.getFamily() == ImageType.Family.MULTI_SPECTRAL) {
            DescribePointSurfMultiSpectral describeMulti = new DescribePointSurfMultiSpectral(describe, imageType.getNumBands());
            DetectDescribeSurfMultiSpectral deteDesc = new DetectDescribeSurfMultiSpectral(detector, orientation, describeMulti);
            return new SurfMultiSpectral_to_DetectDescribePoint(deteDesc, bandType, integralType);
        }
        throw new IllegalArgumentException("Image type not supported");
    }

    public static <T extends ImageSingleBand, D extends TupleDesc> DetectDescribePoint<T, D> fuseTogether(InterestPointDetector<T> detector, OrientationImage<T> orientation, DescribeRegionPoint<T, D> describe) {
        return new DetectDescribeFusion<T, D>(detector, orientation, describe);
    }
}

