/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line.gridline;

import boofcv.alg.feature.detect.line.gridline.Edgel;
import georegression.fitting.line.FitLine_F32;
import georegression.metric.UtilAngle;
import georegression.struct.line.LinePolar2D_F32;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;

public class GridLineModelFitter
implements ModelGenerator<LinePolar2D_F32, Edgel> {
    float angleTol;

    public GridLineModelFitter(float angleTol) {
        this.angleTol = angleTol;
    }

    public boolean generate(List<Edgel> dataSet, LinePolar2D_F32 model) {
        if (dataSet.size() == 2) {
            Edgel a = dataSet.get(0);
            Edgel b = dataSet.get(1);
            float dx = b.x - a.x;
            float dy = b.y - a.y;
            double lineAngle = UtilAngle.atanSafe((float)(-dx), (float)dy);
            if (UtilAngle.distHalf((double)lineAngle, (double)a.theta) > (double)this.angleTol || UtilAngle.distHalf((double)lineAngle, (double)b.theta) > (double)this.angleTol) {
                return false;
            }
        }
        FitLine_F32.polar(dataSet, (LinePolar2D_F32)model);
        return true;
    }

    public int getMinimumPoints() {
        return 2;
    }
}

