/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.InputSanityCheck;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import java.util.Arrays;

public abstract class DenseOpticalFlowBlockPyramid<T extends ImageGray> {
    protected int searchRadius;
    protected int regionRadius;
    protected T template;
    protected int maxError;
    protected ImageFlow flowPrevLayer = new ImageFlow(1, 1);
    protected ImageFlow flowCurrLayer = new ImageFlow(1, 1);
    protected ImageFlow.D tmp = new ImageFlow.D();
    protected float[] scores = new float[0];

    public DenseOpticalFlowBlockPyramid(int searchRadius, int regionRadius, int maxPerPixelError, Class<T> imageType) {
        this.searchRadius = searchRadius;
        this.regionRadius = regionRadius;
        int w = regionRadius * 2 + 1;
        this.maxError = maxPerPixelError * w * w;
        this.template = GeneralizedImageOps.createSingleBand(imageType, (int)w, (int)w);
    }

    public void process(ImagePyramid<T> pyramidPrev, ImagePyramid<T> pyramidCurr) {
        InputSanityCheck.checkSameShape(pyramidPrev, pyramidCurr);
        int numLayers = pyramidPrev.getNumLayers();
        for (int i = numLayers - 1; i >= 0; --i) {
            ImageGray prev = (ImageGray)pyramidPrev.getLayer(i);
            ImageGray curr = (ImageGray)pyramidCurr.getLayer(i);
            this.flowCurrLayer.reshape(prev.width, prev.height);
            int N = prev.width * prev.height;
            if (this.scores.length < N) {
                this.scores = new float[N];
            }
            Arrays.fill(this.scores, 0, N, Float.MAX_VALUE);
            int x1 = prev.width - this.regionRadius;
            int y1 = prev.height - this.regionRadius;
            if (i == numLayers - 1) {
                for (int y = this.regionRadius; y < y1; ++y) {
                    for (int x = this.regionRadius; x < x1; ++x) {
                        this.extractTemplate(x, y, prev);
                        float score = this.findFlow(x, y, curr, this.tmp);
                        if (this.tmp.isValid()) {
                            this.checkNeighbors(x, y, this.tmp, this.flowCurrLayer, score);
                            continue;
                        }
                        this.flowCurrLayer.unsafe_get(x, y).markInvalid();
                    }
                }
            } else {
                double scale = pyramidPrev.getScale(i + 1) / pyramidPrev.getScale(i);
                for (int y = this.regionRadius; y < y1; ++y) {
                    for (int x = this.regionRadius; x < x1; ++x) {
                        ImageFlow.D p = this.flowPrevLayer.get((int)((double)x / scale), (int)((double)y / scale));
                        if (!p.isValid()) continue;
                        this.extractTemplate(x, y, prev);
                        int deltaX = (int)((double)p.x * scale + 0.5);
                        int deltaY = (int)((double)p.y * scale + 0.5);
                        int startX = x + deltaX;
                        int startY = y + deltaY;
                        float score = this.findFlow(startX, startY, curr, this.tmp);
                        this.tmp.x += (float)deltaX;
                        this.tmp.y += (float)deltaY;
                        if (this.tmp.isValid()) {
                            this.checkNeighbors(x, y, this.tmp, this.flowCurrLayer, score);
                            continue;
                        }
                        this.flowCurrLayer.unsafe_get(x, y).markInvalid();
                    }
                }
            }
            ImageFlow tmp = this.flowPrevLayer;
            this.flowPrevLayer = this.flowCurrLayer;
            this.flowCurrLayer = tmp;
        }
    }

    protected float findFlow(int cx, int cy, T curr, ImageFlow.D flow) {
        float bestScore = Float.MAX_VALUE;
        int bestFlowX = 0;
        int bestFlowY = 0;
        int startY = cy - this.searchRadius - this.regionRadius < 0 ? Math.max(this.regionRadius - cy, 0) : -this.searchRadius;
        int startX = cx - this.searchRadius - this.regionRadius < 0 ? Math.max(this.regionRadius - cx, 0) : -this.searchRadius;
        int endY = cy + this.searchRadius + this.regionRadius >= ((ImageGray)curr).height ? ((ImageGray)curr).height - cy - this.regionRadius - 1 : this.searchRadius;
        int endX = cx + this.searchRadius + this.regionRadius >= ((ImageGray)curr).width ? ((ImageGray)curr).width - cx - this.regionRadius - 1 : this.searchRadius;
        for (int i = startY; i <= endY; ++i) {
            int y = cy + i;
            for (int j = startX; j <= endX; ++j) {
                float m1;
                float m0;
                int x = cx + j;
                float error = this.computeError(x, y, curr);
                if (error < bestScore) {
                    bestScore = error;
                    bestFlowX = j;
                    bestFlowY = i;
                    continue;
                }
                if (error != bestScore || !((m0 = (float)(j * j + i * i)) < (m1 = (float)(bestFlowX * bestFlowX + bestFlowY * bestFlowY)))) continue;
                bestFlowX = j;
                bestFlowY = i;
            }
        }
        if (bestScore <= (float)this.maxError) {
            flow.x = bestFlowX;
            flow.y = bestFlowY;
            return bestScore;
        }
        flow.markInvalid();
        return Float.NaN;
    }

    protected void checkNeighbors(int cx, int cy, ImageFlow.D flow, ImageFlow image, float score) {
        for (int i = -this.regionRadius; i <= this.regionRadius; ++i) {
            int index = image.width * (cy + i) + (cx - this.regionRadius);
            int j = -this.regionRadius;
            while (j <= this.regionRadius) {
                float m0;
                float m1;
                float s = this.scores[index];
                ImageFlow.D f = image.data[index];
                if (s > score) {
                    f.set(flow);
                    this.scores[index] = score;
                } else if (s == score && (m1 = flow.x * flow.x + flow.y * flow.y) < (m0 = f.x * f.x + f.y * f.y)) {
                    f.set(flow);
                    this.scores[index] = score;
                }
                ++j;
                ++index;
            }
        }
    }

    protected abstract void extractTemplate(int var1, int var2, T var3);

    protected abstract float computeError(int var1, int var2, T var3);

    public ImageFlow getOpticalFlow() {
        return this.flowPrevLayer;
    }

    public int getSearchRadius() {
        return this.searchRadius;
    }

    public int getRegionRadius() {
        return this.regionRadius;
    }

    public static class F32
    extends DenseOpticalFlowBlockPyramid<GrayF32> {
        public F32(int searchRadius, int regionRadius, int maxPerPixelError) {
            super(searchRadius, regionRadius, maxPerPixelError, GrayF32.class);
        }

        @Override
        protected void extractTemplate(int cx, int cy, GrayF32 prev) {
            int index = 0;
            for (int i = -this.regionRadius; i <= this.regionRadius; ++i) {
                int indexPrev = prev.startIndex + prev.stride * (i + cy) + cx - this.regionRadius;
                for (int j = -this.regionRadius; j <= this.regionRadius; ++j) {
                    ((GrayF32)this.template).data[index++] = prev.data[indexPrev++];
                }
            }
        }

        @Override
        protected float computeError(int cx, int cy, GrayF32 curr) {
            int index = 0;
            float error = 0.0f;
            for (int i = -this.regionRadius; i <= this.regionRadius; ++i) {
                int indexPrev = curr.startIndex + curr.stride * (i + cy) + cx - this.regionRadius;
                for (int j = -this.regionRadius; j <= this.regionRadius; ++j) {
                    float e;
                    error += (e = ((GrayF32)this.template).data[index++] - curr.data[indexPrev++]) < 0.0f ? -e : e;
                }
            }
            return error;
        }
    }

    public static class U8
    extends DenseOpticalFlowBlockPyramid<GrayU8> {
        public U8(int searchRadius, int regionRadius, int maxPerPixelError) {
            super(searchRadius, regionRadius, maxPerPixelError, GrayU8.class);
        }

        @Override
        protected void extractTemplate(int cx, int cy, GrayU8 prev) {
            int index = 0;
            for (int i = -this.regionRadius; i <= this.regionRadius; ++i) {
                int indexPrev = prev.startIndex + prev.stride * (i + cy) + cx - this.regionRadius;
                for (int j = -this.regionRadius; j <= this.regionRadius; ++j) {
                    ((GrayU8)this.template).data[index++] = prev.data[indexPrev++];
                }
            }
        }

        @Override
        protected float computeError(int cx, int cy, GrayU8 curr) {
            int index = 0;
            int error = 0;
            for (int i = -this.regionRadius; i <= this.regionRadius; ++i) {
                int indexPrev = curr.startIndex + curr.stride * (i + cy) + cx - this.regionRadius;
                for (int j = -this.regionRadius; j <= this.regionRadius; ++j) {
                    int e;
                    error += (e = (((GrayU8)this.template).data[index++] & 0xFF) - (curr.data[indexPrev++] & 0xFF)) < 0 ? -e : e;
                }
            }
            return error;
        }
    }
}

