/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F64;

public class WrapSiftDetector<T extends ImageBase>
implements InterestPointDetector<T> {
    SiftDetector detector;
    GrayF32 imageFloat = new GrayF32(1, 1);
    Class<T> inputType;

    public WrapSiftDetector(SiftDetector detector, Class<T> inputType) {
        this.detector = detector;
        this.inputType = inputType;
    }

    @Override
    public void detect(T image) {
        GrayF32 input;
        if (image instanceof GrayF32) {
            input = (GrayF32)image;
        } else {
            this.imageFloat.reshape(((ImageBase)image).width, ((ImageBase)image).height);
            GConvertImage.convert(image, (ImageBase)this.imageFloat);
            input = this.imageFloat;
        }
        this.detector.process(input);
    }

    @Override
    public int getNumberOfFeatures() {
        return this.detector.getDetections().size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.detector.getDetections().get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return ((ScalePoint)((Object)this.detector.getDetections().get((int)featureIndex))).scale;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return true;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }
}

