/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.flow.ConfigBroxWarping;
import boofcv.alg.flow.DenseFlowPyramidBase;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.misc.PixelMath;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import java.util.Arrays;

public class BroxWarpingSpacial<T extends ImageGray>
extends DenseFlowPyramidBase<T> {
    private static final double EPSILON = 0.001;
    protected float alpha;
    protected float gamma;
    private float SOR_RELAXATION;
    private int numOuter;
    private int numInner;
    private int maxIterationsSor;
    private float convergeTolerance;
    private GrayF32 deriv1X = new GrayF32(1, 1);
    private GrayF32 deriv1Y = new GrayF32(1, 1);
    private GrayF32 deriv2X = new GrayF32(1, 1);
    private GrayF32 deriv2Y = new GrayF32(1, 1);
    private GrayF32 deriv2XX = new GrayF32(1, 1);
    private GrayF32 deriv2YY = new GrayF32(1, 1);
    private GrayF32 deriv2XY = new GrayF32(1, 1);
    private ImageGradient<GrayF32, GrayF32> gradient = FactoryDerivative.three(GrayF32.class, GrayF32.class);
    private ImageHessian<GrayF32> hessian = FactoryDerivative.hessianThree(GrayF32.class);
    protected GrayF32 flowU = new GrayF32(1, 1);
    protected GrayF32 flowV = new GrayF32(1, 1);
    protected GrayF32 warpImage2 = new GrayF32(1, 1);
    protected GrayF32 warpDeriv2X = new GrayF32(1, 1);
    protected GrayF32 warpDeriv2Y = new GrayF32(1, 1);
    protected GrayF32 warpDeriv2XX = new GrayF32(1, 1);
    protected GrayF32 warpDeriv2YY = new GrayF32(1, 1);
    protected GrayF32 warpDeriv2XY = new GrayF32(1, 1);
    protected GrayF32 derivFlowUX = new GrayF32(1, 1);
    protected GrayF32 derivFlowUY = new GrayF32(1, 1);
    protected GrayF32 derivFlowVX = new GrayF32(1, 1);
    protected GrayF32 derivFlowVY = new GrayF32(1, 1);
    protected GrayF32 psiSmooth = new GrayF32(1, 1);
    protected GrayF32 psiData = new GrayF32(1, 1);
    protected GrayF32 psiGradient = new GrayF32(1, 1);
    protected GrayF32 divU = new GrayF32(1, 1);
    protected GrayF32 divV = new GrayF32(1, 1);
    protected GrayF32 divD = new GrayF32(1, 1);
    protected GrayF32 du = new GrayF32(1, 1);
    protected GrayF32 dv = new GrayF32(1, 1);

    public BroxWarpingSpacial(ConfigBroxWarping config, InterpolatePixelS<GrayF32> interp) {
        super(config.pyrScale, config.pyrSigma, config.pyrMaxLayers, interp);
        this.alpha = config.alpha;
        this.gamma = config.gamma;
        this.SOR_RELAXATION = config.SOR_RELAXATION;
        this.numOuter = config.numOuter;
        this.numInner = config.numInner;
        this.maxIterationsSor = config.maxIterationsSor;
        this.convergeTolerance = config.convergeToleranceSor;
    }

    @Override
    public void process(ImagePyramid<GrayF32> image1, ImagePyramid<GrayF32> image2) {
        boolean first = true;
        for (int i = image1.getNumLayers() - 1; i >= 0; --i) {
            GrayF32 layer1 = (GrayF32)image1.getLayer(i);
            GrayF32 layer2 = (GrayF32)image2.getLayer(i);
            this.resizeForLayer(layer1.width, layer2.height);
            this.gradient.process((ImageBase)layer1, (ImageBase)this.deriv1X, (ImageBase)this.deriv1Y);
            this.gradient.process((ImageBase)layer2, (ImageBase)this.deriv2X, (ImageBase)this.deriv2Y);
            this.hessian.process((ImageGray)this.deriv2X, (ImageGray)this.deriv2Y, (ImageGray)this.deriv2XX, (ImageGray)this.deriv2YY, (ImageGray)this.deriv2XY);
            if (!first) {
                this.interpolateFlowScale(layer1.width, layer1.height);
            } else {
                first = false;
                this.flowU.reshape(layer1.width, layer1.height);
                this.flowV.reshape(layer1.width, layer1.height);
                ImageMiscOps.fill((GrayF32)this.flowU, (float)0.0f);
                ImageMiscOps.fill((GrayF32)this.flowV, (float)0.0f);
            }
            this.processLayer(layer1, layer2, this.deriv1X, this.deriv1Y, this.deriv2X, this.deriv2Y, this.deriv2XX, this.deriv2YY, this.deriv2XY);
        }
    }

    protected void resizeForLayer(int width, int height) {
        this.deriv1X.reshape(width, height);
        this.deriv1Y.reshape(width, height);
        this.deriv2X.reshape(width, height);
        this.deriv2Y.reshape(width, height);
        this.deriv2XX.reshape(width, height);
        this.deriv2YY.reshape(width, height);
        this.deriv2XY.reshape(width, height);
        this.warpImage2.reshape(width, height);
        this.warpDeriv2X.reshape(width, height);
        this.warpDeriv2Y.reshape(width, height);
        this.warpDeriv2XX.reshape(width, height);
        this.warpDeriv2YY.reshape(width, height);
        this.warpDeriv2XY.reshape(width, height);
        this.derivFlowUX.reshape(width, height);
        this.derivFlowUY.reshape(width, height);
        this.derivFlowVX.reshape(width, height);
        this.derivFlowVY.reshape(width, height);
        this.psiData.reshape(width, height);
        this.psiGradient.reshape(width, height);
        this.psiSmooth.reshape(width, height);
        this.divU.reshape(width, height);
        this.divV.reshape(width, height);
        this.divD.reshape(width, height);
        this.du.reshape(width, height);
        this.dv.reshape(width, height);
    }

    protected void interpolateFlowScale(int widthNew, int heightNew) {
        GrayF32 enlargedU = this.warpDeriv2X;
        GrayF32 enlargedV = this.warpDeriv2Y;
        this.interpolateFlowScale(this.flowU, enlargedU);
        this.interpolateFlowScale(this.flowV, enlargedV);
        this.flowU.reshape(widthNew, heightNew);
        this.flowV.reshape(widthNew, heightNew);
        this.flowU.setTo((ImageGray)enlargedU);
        this.flowV.setTo((ImageGray)enlargedV);
    }

    protected void processLayer(GrayF32 image1, GrayF32 image2, GrayF32 deriv1X, GrayF32 deriv1Y, GrayF32 deriv2X, GrayF32 deriv2Y, GrayF32 deriv2XX, GrayF32 deriv2YY, GrayF32 deriv2XY) {
        int N = image1.width * image1.height;
        int stride = image1.stride;
        for (int indexOuter = 0; indexOuter < this.numOuter; ++indexOuter) {
            this.warpImageTaylor(image2, this.flowU, this.flowV, this.warpImage2);
            this.warpImageTaylor(deriv2X, this.flowU, this.flowV, this.warpDeriv2X);
            this.warpImageTaylor(deriv2Y, this.flowU, this.flowV, this.warpDeriv2Y);
            this.warpImageTaylor(deriv2XX, this.flowU, this.flowV, this.warpDeriv2XX);
            this.warpImageTaylor(deriv2YY, this.flowU, this.flowV, this.warpDeriv2YY);
            this.warpImageTaylor(deriv2XY, this.flowU, this.flowV, this.warpDeriv2XY);
            this.gradient.process((ImageBase)this.flowU, (ImageBase)this.derivFlowUX, (ImageBase)this.derivFlowUY);
            this.gradient.process((ImageBase)this.flowV, (ImageBase)this.derivFlowVX, (ImageBase)this.derivFlowVY);
            this.computePsiSmooth(this.derivFlowUX, this.derivFlowUY, this.derivFlowVX, this.derivFlowVY, this.psiSmooth);
            this.computeDivUVD(this.flowU, this.flowV, this.psiSmooth, this.divU, this.divV, this.divD);
            Arrays.fill(this.du.data, 0, N, 0.0f);
            Arrays.fill(this.dv.data, 0, N, 0.0f);
            for (int indexInner = 0; indexInner < this.numInner; ++indexInner) {
                float error;
                this.computePsiDataPsiGradient(image1, image2, deriv1X, deriv1Y, deriv2X, deriv2Y, deriv2XX, deriv2YY, deriv2XY, this.du, this.dv, this.psiData, this.psiGradient);
                int iter = 0;
                do {
                    int x;
                    error = 0.0f;
                    for (int y = 1; y < image1.height - 1; ++y) {
                        int i = y * image1.width + 1;
                        x = 1;
                        while (x < image1.width - 1) {
                            error += this.iterationSor(image1, deriv1X, deriv1Y, i, i + 1, i - 1, i + stride, i - stride);
                            ++x;
                            ++i;
                        }
                    }
                    int y0 = 0;
                    int y1 = image1.height - 1;
                    for (x = 0; x < image1.width; ++x) {
                        error += this.iterationSor(image1, deriv1X, deriv1Y, this.s(x, y0), this.s(x + 1, y0), this.s(x - 1, y0), this.s(x, y0 - 1), this.s(x, y0 + 1));
                        error += this.iterationSor(image1, deriv1X, deriv1Y, this.s(x, y1), this.s(x + 1, y1), this.s(x - 1, y1), this.s(x, y1 - 1), this.s(x, y1 + 1));
                    }
                    int x0 = 0;
                    int x1 = image1.width - 1;
                    for (int y = 1; y < image1.height - 1; ++y) {
                        error += this.iterationSor(image1, deriv1X, deriv1Y, this.s(x0, y), this.s(x0 - 1, y), this.s(x0 + 1, y), this.s(x0, y - 1), this.s(x0, y + 1));
                        error += this.iterationSor(image1, deriv1X, deriv1Y, this.s(x1, y), this.s(x1 - 1, y), this.s(x1 + 1, y), this.s(x1, y - 1), this.s(x1, y + 1));
                    }
                } while (error > this.convergeTolerance * (float)image1.width * (float)image1.height && ++iter < this.maxIterationsSor);
            }
            PixelMath.add((GrayF32)this.flowU, (GrayF32)this.du, (GrayF32)this.flowU);
            PixelMath.add((GrayF32)this.flowV, (GrayF32)this.dv, (GrayF32)this.flowV);
        }
    }

    private float iterationSor(GrayF32 image1, GrayF32 deriv1X, GrayF32 deriv1Y, int i, int ipx, int imx, int ipy, int imy) {
        float w = this.SOR_RELAXATION;
        float psid = this.psiData.data[i];
        float psig = this.gamma * this.psiGradient.data[i];
        float di = this.warpImage2.data[i] - image1.data[i];
        float dx2 = this.warpDeriv2X.data[i];
        float dy2 = this.warpDeriv2Y.data[i];
        float dxx2 = this.warpDeriv2XX.data[i];
        float dyy2 = this.warpDeriv2YY.data[i];
        float dxy2 = this.warpDeriv2XY.data[i];
        float Au = -psid * di * dx2 + this.alpha * this.divU.data[i] - psig * ((dx2 - deriv1X.data[i]) * this.warpDeriv2XX.data[i] + (dy2 - deriv1Y.data[i]) * this.warpDeriv2XY.data[i]);
        float Av = -psid * di * dy2 + this.alpha * this.divV.data[i] - psig * ((dx2 - deriv1X.data[i]) * this.warpDeriv2XY.data[i] + (dy2 - deriv1Y.data[i]) * this.warpDeriv2YY.data[i]);
        float Du = psid * dx2 * dx2 + psig * (dxx2 * dxx2 + dxy2 * dxy2) + this.alpha * this.divD.data[i];
        float Dv = psid * dy2 * dy2 + psig * (dyy2 * dyy2 + dxy2 * dxy2) + this.alpha * this.divD.data[i];
        float D2 = psid * dx2 * dy2 + psig * (dxx2 + dyy2) * dxy2;
        float psi_index = this.psiSmooth.data[i];
        float coef0 = 0.5f * (this.psiSmooth.data[ipx] + psi_index);
        float coef1 = 0.5f * (this.psiSmooth.data[imx] + psi_index);
        float coef2 = 0.5f * (this.psiSmooth.data[ipy] + psi_index);
        float coef3 = 0.5f * (this.psiSmooth.data[imy] + psi_index);
        float div_du = coef0 * this.du.data[ipx] + coef1 * this.du.data[imx] + coef2 * this.du.data[ipy] + coef3 * this.du.data[imy];
        float div_dv = coef0 * this.dv.data[ipx] + coef1 * this.dv.data[imx] + coef2 * this.dv.data[ipy] + coef3 * this.dv.data[imy];
        float dui = this.du.data[i];
        float dvi = this.dv.data[i];
        this.du.data[i] = (1.0f - w) * dui + w * (Au - D2 * dvi + this.alpha * div_du) / Du;
        this.dv.data[i] = (1.0f - w) * dvi + w * (Av - D2 * this.du.data[i] + this.alpha * div_dv) / Dv;
        return (this.du.data[i] - dui) * (this.du.data[i] - dui) + (this.dv.data[i] - dvi) * (this.dv.data[i] - dvi);
    }

    private void computePsiSmooth(GrayF32 ux, GrayF32 uy, GrayF32 vx, GrayF32 vy, GrayF32 psiSmooth) {
        int N = this.derivFlowUX.width * this.derivFlowUX.height;
        for (int i = 0; i < N; ++i) {
            float vux = ux.data[i];
            float vuy = uy.data[i];
            float vvx = vx.data[i];
            float vvy = vy.data[i];
            float mu = vux * vux + vuy * vuy;
            float mv = vvx * vvx + vvy * vvy;
            psiSmooth.data[i] = (float)(1.0 / (2.0 * Math.sqrt((double)(mu + mv) + 1.0E-6)));
        }
    }

    protected void computePsiDataPsiGradient(GrayF32 image1, GrayF32 image2, GrayF32 deriv1x, GrayF32 deriv1y, GrayF32 deriv2x, GrayF32 deriv2y, GrayF32 deriv2xx, GrayF32 deriv2yy, GrayF32 deriv2xy, GrayF32 du, GrayF32 dv, GrayF32 psiData, GrayF32 psiGradient) {
        int N = image1.width * image1.height;
        for (int i = 0; i < N; ++i) {
            float du_ = du.data[i];
            float dv_ = dv.data[i];
            float taylor2 = image2.data[i] + deriv2x.data[i] * du_ + deriv2y.data[i] * dv_;
            float v = taylor2 - image1.data[i];
            psiData.data[i] = (float)(1.0 / (2.0 * Math.sqrt((double)(v * v) + 1.0E-6)));
            float dIx = deriv2x.data[i] + deriv2xx.data[i] * du_ + deriv2xy.data[i] * dv_ - deriv1x.data[i];
            float dIy = deriv2y.data[i] + deriv2xy.data[i] * du_ + deriv2yy.data[i] * dv_ - deriv1y.data[i];
            float dI2 = dIx * dIx + dIy * dIy;
            psiGradient.data[i] = (float)(1.0 / (2.0 * Math.sqrt((double)dI2 + 1.0E-6)));
        }
    }

    private void computeDivUVD(GrayF32 u, GrayF32 v, GrayF32 psi, GrayF32 divU, GrayF32 divV, GrayF32 divD) {
        int y;
        int stride = psi.stride;
        for (y = 1; y < psi.height - 1; ++y) {
            int index = y * stride + 1;
            int x = 1;
            while (x < psi.width - 1) {
                float psi_index = psi.data[index];
                float coef0 = 0.5f * (psi.data[index + 1] + psi_index);
                float coef1 = 0.5f * (psi.data[index - 1] + psi_index);
                float coef2 = 0.5f * (psi.data[index + stride] + psi_index);
                float coef3 = 0.5f * (psi.data[index - stride] + psi_index);
                float u_index = u.data[index];
                divU.data[index] = coef0 * (u.data[index + 1] - u_index) + coef1 * (u.data[index - 1] - u_index) + coef2 * (u.data[index + stride] - u_index) + coef3 * (u.data[index - stride] - u_index);
                float v_index = v.data[index];
                divV.data[index] = coef0 * (v.data[index + 1] - v_index) + coef1 * (v.data[index - 1] - v_index) + coef2 * (v.data[index + stride] - v_index) + coef3 * (v.data[index - stride] - v_index);
                divD.data[index] = coef0 + coef1 + coef2 + coef3;
                ++x;
                ++index;
            }
        }
        for (int x = 0; x < psi.width; ++x) {
            this.computeDivUVD_safe(x, 0, u, v, psi, divU, divV, divD);
            this.computeDivUVD_safe(x, psi.height - 1, u, v, psi, divU, divV, divD);
        }
        for (y = 1; y < psi.height - 1; ++y) {
            this.computeDivUVD_safe(0, y, u, v, psi, divU, divV, divD);
            this.computeDivUVD_safe(psi.width - 1, y, u, v, psi, divU, divV, divD);
        }
    }

    protected void computeDivUVD_safe(int x, int y, GrayF32 u, GrayF32 v, GrayF32 psi, GrayF32 divU, GrayF32 divV, GrayF32 divD) {
        int index = u.getIndex(x, y);
        int index_px = this.s(x + 1, y);
        int index_mx = this.s(x - 1, y);
        int index_py = this.s(x, y + 1);
        int index_my = this.s(x, y - 1);
        float psi_index = psi.data[index];
        float coef0 = 0.5f * (psi.data[index_px] + psi_index);
        float coef1 = 0.5f * (psi.data[index_mx] + psi_index);
        float coef2 = 0.5f * (psi.data[index_py] + psi_index);
        float coef3 = 0.5f * (psi.data[index_my] + psi_index);
        float u_index = u.data[index];
        divU.data[index] = coef0 * (u.data[index_px] - u_index) + coef1 * (u.data[index_mx] - u_index) + coef2 * (u.data[index_py] - u_index) + coef3 * (u.data[index_my] - u_index);
        float v_index = v.data[index];
        divV.data[index] = coef0 * (v.data[index_px] - v_index) + coef1 * (v.data[index_mx] - v_index) + coef2 * (v.data[index_py] - v_index) + coef3 * (v.data[index_my] - v_index);
        divD.data[index] = coef0 + coef1 + coef2 + coef3;
    }

    protected int s(int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= this.warpImage2.width) {
            x = this.warpImage2.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= this.warpImage2.height) {
            y = this.warpImage2.height - 1;
        }
        return this.warpImage2.getIndex(x, y);
    }

    public GrayF32 getFlowX() {
        return this.flowU;
    }

    public GrayF32 getFlowY() {
        return this.flowV;
    }
}

