/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.describe.DescribeSiftCommon;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public abstract class DescribeDenseHogAlg<Input extends ImageBase, Derivative extends ImageBase> {
    ImageGradient<Input, Derivative> gradient;
    protected Derivative derivX;
    protected Derivative derivY;
    FastQueue<TupleDesc_F64> descriptions;
    FastQueue<Point2D_I32> locations = new FastQueue(Point2D_I32.class, true);
    int orientationBins;
    int widthCell;
    int widthBlock;
    int stepBlock;
    Cell[] cells = new Cell[0];
    int cellRows;
    int cellCols;
    protected float pixelDX;
    protected float pixelDY;
    double[] weights;
    ImageType<Input> imageType;

    public DescribeDenseHogAlg(int orientationBins, int widthCell, int widthBlock, int stepBlock, ImageType<Input> imageType) {
        if (stepBlock <= 0) {
            throw new IllegalArgumentException("stepBlock must be >= 1");
        }
        this.imageType = imageType;
        this.gradient = FactoryDerivative.gradient((DerivativeType)DerivativeType.THREE, imageType, null);
        ImageType derivType = this.gradient.getDerivativeType();
        this.derivX = derivType.createImage(1, 1);
        this.derivY = derivType.createImage(1, 1);
        this.orientationBins = orientationBins;
        this.widthCell = widthCell;
        this.widthBlock = widthBlock;
        this.stepBlock = stepBlock;
        this.descriptions = new FastQueue<TupleDesc_F64>(TupleDesc_F64.class, true){

            protected TupleDesc_F64 createInstance() {
                return new TupleDesc_F64(DescribeDenseHogAlg.this.orientationBins * DescribeDenseHogAlg.this.widthBlock * DescribeDenseHogAlg.this.widthBlock);
            }
        };
        this.computeCellWeights();
    }

    protected void computeCellWeights() {
        Kernel2D_F64 kernel = FactoryKernelGaussian.gaussian2D_F64((double)(0.5 * (double)this.widthBlock), (int)(this.widthBlock / 2), (this.widthBlock % 2 == 1 ? 1 : 0) != 0, (boolean)false);
        KernelMath.normalizeMaxOne((Kernel2D_F64)kernel);
        this.weights = kernel.data;
    }

    public void setInput(Input input) {
        this.derivX.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.derivY.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
    }

    public void process() {
        this.locations.reset();
        this.descriptions.reset();
        this.growCellArray(((ImageBase)this.derivX).width, ((ImageBase)this.derivX).height);
        this.computeCellHistograms();
        int cellRowMax = this.cellRows - (this.widthBlock - 1);
        int cellColMax = this.cellCols - (this.widthBlock - 1);
        for (int i = 0; i < cellRowMax; i += this.stepBlock) {
            for (int j = 0; j < cellColMax; j += this.stepBlock) {
                this.computeDescriptor(i, j);
            }
        }
    }

    void growCellArray(int imageWidth, int imageHeight) {
        this.cellCols = imageWidth / this.widthCell;
        this.cellRows = imageHeight / this.widthCell;
        if (this.cellRows * this.cellCols > this.cells.length) {
            Cell[] a = new Cell[this.cellCols * this.cellRows];
            System.arraycopy(this.cells, 0, a, 0, this.cells.length);
            for (int i = this.cells.length; i < a.length; ++i) {
                a[i] = new Cell();
                a[i].histogram = new float[this.orientationBins];
            }
            this.cells = a;
        }
    }

    public void getDescriptorsInRegion(int pixelX0, int pixelY0, int pixelX1, int pixelY1, List<TupleDesc_F64> output) {
        int gridX0 = (int)Math.ceil((double)pixelX0 / (double)this.widthCell);
        int gridY0 = (int)Math.ceil((double)pixelY0 / (double)this.widthCell);
        int gridX1 = pixelX1 / this.widthCell - this.widthBlock;
        int gridY1 = pixelY1 / this.widthCell - this.widthBlock;
        for (int y = gridY0; y <= gridY1; ++y) {
            int index = y * this.cellCols + gridX0;
            for (int x = gridX0; x <= gridX1; ++x) {
                output.add((TupleDesc_F64)this.descriptions.get(index++));
            }
        }
    }

    void computeDescriptor(int row, int col) {
        ((Point2D_I32)this.locations.grow()).set(col * this.widthCell, row * this.widthCell);
        TupleDesc_F64 d = (TupleDesc_F64)this.descriptions.grow();
        int indexDesc = 0;
        for (int i = 0; i < this.widthBlock; ++i) {
            for (int j = 0; j < this.widthBlock; ++j) {
                Cell c = this.cells[(row + i) * this.cellCols + (col + j)];
                double w = this.weights[i * this.widthBlock + j];
                for (int k = 0; k < c.histogram.length; ++k) {
                    d.value[indexDesc++] = (double)c.histogram[k] * w;
                }
            }
        }
        DescribeSiftCommon.normalizeDescriptor(d, 0.2);
    }

    void computeCellHistograms() {
        int width = this.cellCols * this.widthCell;
        int height = this.cellRows * this.widthCell;
        float angleBinSize = GrlConstants.F_PI / (float)this.orientationBins;
        int indexCell = 0;
        for (int i = 0; i < height; i += this.widthCell) {
            int j = 0;
            while (j < width) {
                Cell c = this.cells[indexCell];
                c.reset();
                for (int k = 0; k < this.widthCell; ++k) {
                    int indexPixel = (i + k) * ((ImageBase)this.derivX).width + j;
                    int l = 0;
                    while (l < this.widthCell) {
                        this.computeDerivative(indexPixel);
                        float angle = UtilAngle.atanSafe((float)this.pixelDY, (float)this.pixelDX) + GrlConstants.F_PId2;
                        float magnitude = (float)Math.sqrt(this.pixelDX * this.pixelDX + this.pixelDY * this.pixelDY);
                        float findex0 = angle / angleBinSize;
                        int index0 = (int)findex0;
                        float weight1 = findex0 - (float)index0;
                        int index1 = ((index0 %= this.orientationBins) + 1) % this.orientationBins;
                        int n = index0;
                        c.histogram[n] = c.histogram[n] + magnitude * (1.0f - weight1);
                        int n2 = index1;
                        c.histogram[n2] = c.histogram[n2] + magnitude * weight1;
                        ++l;
                        ++indexPixel;
                    }
                }
                j += this.widthCell;
                ++indexCell;
            }
        }
    }

    public abstract void computeDerivative(int var1);

    public FastQueue<Point2D_I32> getLocations() {
        return this.locations;
    }

    public FastQueue<TupleDesc_F64> getDescriptions() {
        return this.descriptions;
    }

    public Derivative _getDerivX() {
        return this.derivX;
    }

    public Derivative _getDerivY() {
        return this.derivY;
    }

    public float _getPixelDX() {
        return this.pixelDX;
    }

    public float _getPixelDY() {
        return this.pixelDY;
    }

    public int getRegionWidthPixel() {
        return this.widthCell * this.widthBlock;
    }

    public void setWidthCell(int widthCell) {
        this.widthCell = widthCell;
    }

    public int getWidthCell() {
        return this.widthCell;
    }

    public int getWidthBlock() {
        return this.widthBlock;
    }

    public int getStepBlock() {
        return this.stepBlock;
    }

    public int getOrientationBins() {
        return this.orientationBins;
    }

    public int getCellRows() {
        return this.cellRows;
    }

    public int getCellCols() {
        return this.cellCols;
    }

    public Cell getCell(int row, int col) {
        return this.cells[row * this.cellCols + col];
    }

    public void setStepBlock(int stepBlock) {
        this.stepBlock = stepBlock;
    }

    public ImageType<Input> getImageType() {
        return this.imageType;
    }

    public TupleDesc_F64 createDescription() {
        return new TupleDesc_F64(this.orientationBins * this.widthBlock * this.widthBlock);
    }

    public static class Cell {
        public float[] histogram;

        public void reset() {
            Arrays.fill(this.histogram, 0.0f);
        }
    }
}

