/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense.impl;

import boofcv.alg.feature.dense.DescribeDenseHogAlg;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class DescribeDenseHogAlg_PLF32
extends DescribeDenseHogAlg<Planar<GrayF32>, Planar<GrayF32>> {
    int numBands;

    public DescribeDenseHogAlg_PLF32(int orientationBins, int widthCell, int widthBlock, int stepBlock, int numBands) {
        super(orientationBins, widthCell, widthBlock, stepBlock, ImageType.pl((int)numBands, GrayF32.class));
        this.numBands = numBands;
    }

    @Override
    public void computeDerivative(int pixelIndex) {
        float maxDX = 0.0f;
        float maxDY = 0.0f;
        float maxNorm = 0.0f;
        for (int i = 0; i < this.numBands; ++i) {
            float dx = ((GrayF32[])((Planar)this.derivX).bands)[i].data[pixelIndex];
            float dy = ((GrayF32[])((Planar)this.derivY).bands)[i].data[pixelIndex];
            float n = dx * dx + dy * dy;
            if (!(n > maxNorm)) continue;
            maxNorm = n;
            maxDX = dx;
            maxDY = dy;
        }
        this.pixelDX = maxDX;
        this.pixelDY = maxDY;
    }
}

