/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.impl;

import boofcv.alg.feature.describe.DescribePointBinaryCompare;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;

public class ImplDescribeBinaryCompare_F32
extends DescribePointBinaryCompare<GrayF32> {
    public ImplDescribeBinaryCompare_F32(BinaryCompareDefinition_I32 definition) {
        super(definition);
    }

    @Override
    public void processInside(int c_x, int c_y, TupleDesc_B feature) {
        Arrays.fill(feature.data, 0);
        int index = ((GrayF32)this.image).startIndex + ((GrayF32)this.image).stride * c_y + c_x;
        for (int i = 0; i < this.definition.compare.length; i += 32) {
            int end = Math.min(this.definition.compare.length, i + 32);
            float valA = ((GrayF32)this.image).data[index + this.offsetsA[i]];
            float valB = ((GrayF32)this.image).data[index + this.offsetsB[i]];
            int desc = valA < valB ? 1 : 0;
            for (int j = i + 1; j < end; ++j) {
                valA = ((GrayF32)this.image).data[index + this.offsetsA[j]];
                valB = ((GrayF32)this.image).data[index + this.offsetsB[j]];
                desc *= 2;
                if (!(valA < valB)) continue;
                ++desc;
            }
            feature.data[i / 32] = desc;
        }
    }

    @Override
    public void processBorder(int c_x, int c_y, TupleDesc_B feature) {
        Arrays.fill(feature.data, 0);
        int index = ((GrayF32)this.image).startIndex + ((GrayF32)this.image).stride * c_y + c_x;
        for (int i = 0; i < this.definition.compare.length; i += 32) {
            int end = Math.min(this.definition.compare.length, i + 32);
            int desc = 0;
            for (int j = i; j < end; ++j) {
                Point2D_I32 c = this.definition.compare[j];
                Point2D_I32 p_a = this.definition.samplePoints[c.x];
                Point2D_I32 p_b = this.definition.samplePoints[c.y];
                if (!((GrayF32)this.image).isInBounds(p_a.x + c_x, p_a.y + c_y) || !((GrayF32)this.image).isInBounds(p_b.x + c_x, p_b.y + c_y)) continue;
                float valA = ((GrayF32)this.image).data[index + this.offsetsA[j]];
                float valB = ((GrayF32)this.image).data[index + this.offsetsB[j]];
                desc *= 2;
                if (!(valA < valB)) continue;
                ++desc;
            }
            feature.data[i / 32] = desc;
        }
    }
}

