/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.struct.image.GrayU8;

public class ImplOrientationImageAverage_U8
extends OrientationImageAverage<GrayU8> {
    public ImplOrientationImageAverage_U8(double objectToSample, int radius) {
        super(objectToSample, radius);
    }

    @Override
    public double computeAngle(int c_x, int c_y) {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int index = ((GrayU8)this.image).startIndex + ((GrayU8)this.image).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.sampleRadius) * this.kerCosine.width + this.rect.x0 - c_x + this.sampleRadius;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                int val = ((GrayU8)this.image).data[index] & 0xFF;
                sumX += this.kerCosine.data[indexW] * (float)val;
                sumY += this.kerSine.data[indexW] * (float)val;
                ++x;
                ++index;
                ++indexW;
            }
        }
        return Math.atan2(sumY, sumX);
    }

    @Override
    public Class<GrayU8> getImageType() {
        return GrayU8.class;
    }
}

