/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.flow.HornSchunck;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;

public class HornSchunck_F32
extends HornSchunck<GrayF32, GrayF32> {
    public HornSchunck_F32(float alpha, int numIterations) {
        super(alpha, numIterations, ImageType.single(GrayF32.class));
    }

    @Override
    protected void computeDerivX(GrayF32 image1, GrayF32 image2, GrayF32 derivX) {
        int y;
        int w = image1.width - 1;
        int h = image1.height - 1;
        for (y = 0; y < h; ++y) {
            int index1 = image1.startIndex + y * image1.stride;
            int index2 = image2.startIndex + y * image2.stride;
            int indexX = derivX.startIndex + y * derivX.stride;
            int x = 0;
            while (x < w) {
                float d0 = image1.data[index1 + 1] - image1.data[index1];
                float d2 = image2.data[index2 + 1] - image2.data[index2];
                float d1 = image1.data[index1 + 1 + image1.stride] - image1.data[index1 + image1.stride];
                float d3 = image2.data[index2 + 1 + image2.stride] - image2.data[index2 + image2.stride];
                derivX.data[indexX] = 0.25f * (d0 + d1 + d2 + d3);
                ++x;
                ++index1;
                ++index2;
                ++indexX;
            }
        }
        for (y = 0; y < image1.height; ++y) {
            derivX.unsafe_set(w, y, 0.0f);
        }
        for (int x = 0; x < w; ++x) {
            float d0 = image1.unsafe_get(x + 1, h) - image1.unsafe_get(x, h);
            float d1 = image2.unsafe_get(x + 1, h) - image2.unsafe_get(x, h);
            derivX.unsafe_set(x, h, 0.5f * (d0 + d1));
        }
    }

    @Override
    protected void computeDerivY(GrayF32 image1, GrayF32 image2, GrayF32 derivY) {
        int y;
        int w = image1.width - 1;
        int h = image1.height - 1;
        for (y = 0; y < h; ++y) {
            int index1 = image1.startIndex + y * image1.stride;
            int index2 = image2.startIndex + y * image2.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int x = 0;
            while (x < w) {
                float d0 = image1.data[index1 + image1.stride] - image1.data[index1];
                float d2 = image2.data[index2 + image2.stride] - image2.data[index2];
                float d1 = image1.data[index1 + 1 + image1.stride] - image1.data[index1 + 1];
                float d3 = image2.data[index2 + 1 + image2.stride] - image2.data[index2 + 1];
                derivY.data[indexY] = 0.25f * (d0 + d1 + d2 + d3);
                ++x;
                ++index1;
                ++index2;
                ++indexY;
            }
        }
        for (y = 0; y < h; ++y) {
            float d0 = image1.unsafe_get(w, y + 1) - image1.unsafe_get(w, y);
            float d1 = image2.unsafe_get(w, y + 1) - image2.unsafe_get(w, y);
            derivY.unsafe_set(w, y, 0.5f * (d0 + d1));
        }
        for (int x = 0; x < w; ++x) {
            derivY.unsafe_set(x, h, 0.0f);
        }
    }

    @Override
    protected void computeDerivT(GrayF32 image1, GrayF32 image2, GrayF32 difference) {
        int y;
        int w = image1.width - 1;
        int h = image1.height - 1;
        for (y = 0; y < h; ++y) {
            int index1 = image1.startIndex + y * image1.stride;
            int index2 = image2.startIndex + y * image2.stride;
            int indexDiff = difference.startIndex + y * difference.stride;
            int x = 0;
            while (x < w) {
                float d0 = image2.data[index2] - image1.data[index1];
                float d1 = image2.data[index2 + 1] - image1.data[index1 + 1];
                float d2 = image2.data[index2 + image2.stride] - image1.data[index1 + image1.stride];
                float d3 = image2.data[index2 + 1 + image2.stride] - image1.data[index1 + 1 + image2.stride];
                difference.data[indexDiff] = 0.25f * (d0 + d1 + d2 + d3);
                ++x;
                ++index1;
                ++index2;
                ++indexDiff;
            }
        }
        for (y = 0; y < image1.height; ++y) {
            HornSchunck_F32.borderDerivT(image1, image2, difference, w, y);
        }
        for (int x = 0; x < w; ++x) {
            HornSchunck_F32.borderDerivT(image1, image2, difference, x, h);
        }
    }

    protected static void borderDerivT(GrayF32 imageA, GrayF32 imageB, GrayF32 difference, int x, int y) {
        float d0 = HornSchunck_F32.getBorderT(imageA, imageB, x, y);
        float d1 = HornSchunck_F32.getBorderT(imageA, imageB, x + 1, y);
        float d2 = HornSchunck_F32.getBorderT(imageA, imageB, x, y + 1);
        float d3 = HornSchunck_F32.getBorderT(imageA, imageB, x + 1, y + 1);
        difference.unsafe_set(x, y, 0.25f * (d0 + d1 + d2 + d3));
    }

    protected static float getBorderT(GrayF32 imageA, GrayF32 imageB, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= imageA.width) {
            x = imageA.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= imageA.height) {
            y = imageA.height - 1;
        }
        return imageB.unsafe_get(x, y) - imageA.unsafe_get(x, y);
    }

    @Override
    protected void findFlow(GrayF32 derivX, GrayF32 derivY, GrayF32 derivT, ImageFlow output) {
        int N = output.width * output.height;
        for (int iter = 0; iter < this.numIterations; ++iter) {
            HornSchunck_F32.borderAverageFlow(output, this.averageFlow);
            HornSchunck_F32.innerAverageFlow(output, this.averageFlow);
            for (int i = 0; i < N; ++i) {
                float dx = derivX.data[i];
                float dy = derivY.data[i];
                float dt = derivT.data[i];
                ImageFlow.D aveFlow = this.averageFlow.data[i];
                float u = aveFlow.x;
                float v = aveFlow.y;
                ImageFlow.D flow = output.data[i];
                float r = (dx * u + dy * v + dt) / (this.alpha2 + dx * dx + dy * dy);
                flow.x = u - dx * r;
                flow.y = v - dy * r;
            }
        }
    }
}

