/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolateType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.InterleavedF32;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingGaussian_IL<T extends ImageInterleaved, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGaussian<T, Motion> {
    protected InterpolatePixelMB<T> interpolateInput;
    protected InterpolatePixelMB<InterleavedF32> interpolationBG;
    protected GImageMultiBand inputWrapper;
    protected float[] pixelBG;
    protected float[] pixelInput;
    InterleavedF32 background;

    public BackgroundMovingGaussian_IL(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolateType interpType, ImageType<T> imageType) {
        super(learnRate, threshold, transform, imageType);
        int numBands = imageType.getNumBands();
        this.interpolateInput = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolateType)InterpolateType.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
        this.background = new InterleavedF32(1, 1, 2 * numBands);
        this.interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolateType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.il((int)(numBands * 2), InterleavedF32.class));
        this.interpolationBG.setImage((ImageBase)this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.pixelBG = new float[2 * numBands];
        this.pixelInput = new float[numBands];
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill((ImageBase)this.background, (double)-1.0);
        this.homeToWorld.set(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill((ImageBase)this.background, (double)-1.0);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, T frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolateInput.setImage(frame);
        float minusLearn = 1.0f - this.learnRate;
        int numBands = this.background.getNumBands() / 2;
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0 * this.background.numBands;
            int x = x0;
            while (x < x1) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)((ImageInterleaved)frame).width && this.work.y >= 0.0f && this.work.y < (float)((ImageInterleaved)frame).height) {
                    this.interpolateInput.get(this.work.x, this.work.y, this.pixelInput);
                    for (int band = 0; band < numBands; ++band) {
                        int indexBG_band = indexBG + band * 2;
                        float inputValue = this.pixelInput[band];
                        float meanBG = this.background.data[indexBG_band];
                        float varianceBG = this.background.data[indexBG_band + 1];
                        if (varianceBG < 0.0f) {
                            this.background.data[indexBG_band] = inputValue;
                            this.background.data[indexBG_band + 1] = this.initialVariance;
                            continue;
                        }
                        float diff = meanBG - inputValue;
                        this.background.data[indexBG_band] = minusLearn * meanBG + this.learnRate * inputValue;
                        this.background.data[indexBG_band + 1] = minusLearn * varianceBG + this.learnRate * diff * diff;
                    }
                }
                ++x;
                indexBG += numBands * 2;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, T frame, GrayU8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float adjustedMinimumDifference = this.minimumDifference * (float)numBands;
        for (int y = 0; y < ((ImageInterleaved)frame).height; ++y) {
            int indexFrame = ((ImageInterleaved)frame).startIndex + y * ((ImageInterleaved)frame).stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < ((ImageInterleaved)frame).width) {
                block11: {
                    this.transform.compute((float)x, (float)y, this.work);
                    if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                        this.interpolationBG.get(this.work.x, this.work.y, this.pixelBG);
                        this.inputWrapper.getF(indexFrame, this.pixelInput);
                        float mahalanobis = 0.0f;
                        for (int band = 0; band < numBands; ++band) {
                            float meanBG = this.pixelBG[band * 2];
                            float varBG = this.pixelBG[band * 2 + 1];
                            if (varBG < 0.0f) {
                                segmented.data[indexSegmented] = this.unknownValue;
                                break block11;
                            }
                            float diff = meanBG - this.pixelInput[band];
                            mahalanobis += diff * diff / varBG;
                        }
                        if (mahalanobis <= this.threshold) {
                            segmented.data[indexSegmented] = 0;
                        } else if (this.minimumDifference > 0.0f) {
                            float sumAbsDiff = 0.0f;
                            for (int band = 0; band < numBands; ++band) {
                                sumAbsDiff += Math.abs(this.pixelBG[band * 2] - this.pixelInput[band]);
                            }
                            segmented.data[indexSegmented] = sumAbsDiff >= adjustedMinimumDifference ? (byte)1 : 0;
                        } else {
                            segmented.data[indexSegmented] = 1;
                        }
                    } else {
                        segmented.data[indexSegmented] = this.unknownValue;
                    }
                }
                ++x;
                indexFrame += numBands;
                ++indexSegmented;
            }
        }
    }
}

