/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.color;

import boofcv.struct.feature.TupleDesc_F64;

public class Histogram_F64
extends TupleDesc_F64 {
    int[] length;
    int[] strides;
    double[] valueMin;
    double[] valueMax;

    public Histogram_F64(int ... lengths) {
        this.length = (int[])lengths.clone();
        this.strides = new int[lengths.length];
        int N = lengths[lengths.length - 1];
        for (int i = 1; i < lengths.length; ++i) {
            this.strides[this.strides.length - i - 1] = N;
            N *= lengths[lengths.length - i - 1];
        }
        this.strides[this.strides.length - 1] = 1;
        this.value = new double[N];
        this.valueMin = new double[lengths.length];
        this.valueMax = new double[lengths.length];
    }

    public boolean isRangeSet() {
        for (int i = 0; i < this.getDimensions(); ++i) {
            if (this.valueMin[i] != 0.0 || this.valueMax[i] != 0.0) continue;
            return false;
        }
        return true;
    }

    public int getDimensions() {
        return this.length.length;
    }

    public int getLength(int dimension) {
        return this.length[dimension];
    }

    public void setRange(int dimension, double min, double max) {
        this.valueMin[dimension] = min;
        this.valueMax[dimension] = max;
    }

    public void setMinimum(int dimension, double value) {
        this.valueMin[dimension] = value;
    }

    public void setMaximum(int dimension, double value) {
        this.valueMax[dimension] = value;
    }

    public double getMinimum(int dimension) {
        return this.valueMin[dimension];
    }

    public double getMaximum(int dimension) {
        return this.valueMax[dimension];
    }

    public int getDimensionIndex(int dimension, double value) {
        double min = this.valueMin[dimension];
        double max = this.valueMax[dimension];
        double fraction = (value - min) / (max - min);
        if (fraction >= 1.0) {
            return this.length[dimension] - 1;
        }
        return (int)(fraction * (double)this.length[dimension]);
    }

    public int getDimensionIndex(int dimension, int value) {
        double min = this.valueMin[dimension];
        double max = this.valueMax[dimension];
        double fraction = ((double)value - min) / (max - min + 1.0);
        return (int)(fraction * (double)this.length[dimension]);
    }

    public final int getIndex(int i, int j) {
        return i * this.strides[0] + j;
    }

    public final int getIndex(int i, int j, int k) {
        return i * this.strides[0] + j * this.strides[1] + k;
    }

    public final int getIndex(int[] coordinate) {
        int index = coordinate[0] * this.strides[0];
        for (int i = 1; i < coordinate.length; ++i) {
            index += this.strides[i] * coordinate[i];
        }
        return index;
    }

    public double get(int i, int j) {
        return this.value[this.getIndex(i, j)];
    }

    public double get(int i, int j, int k) {
        return this.value[this.getIndex(i, j, k)];
    }

    public double get(int[] coordinate) {
        return this.value[this.getIndex(coordinate)];
    }

    @Override
    public Histogram_F64 copy() {
        Histogram_F64 out = this.newInstance();
        System.arraycopy(this.value, 0, out.value, 0, this.length.length);
        return out;
    }

    public Histogram_F64 newInstance() {
        Histogram_F64 out = new Histogram_F64(this.length);
        for (int i = 0; i < this.length.length; ++i) {
            out.setRange(i, this.valueMin[i], this.valueMax[i]);
        }
        return out;
    }
}

