/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.struct.image.GrayF32;

public abstract class ImplSsdCorner_F32
extends ImplSsdCornerBase<GrayF32, GrayF32> {
    private float[] tempXX = new float[1];
    private float[] tempXY = new float[1];
    private float[] tempYY = new float[1];
    protected float totalXX;
    protected float totalYY;
    protected float totalXY;

    public ImplSsdCorner_F32(int windowRadius) {
        super(windowRadius, GrayF32.class);
    }

    @Override
    public void setImageShape(int imageWidth, int imageHeight) {
        super.setImageShape(imageWidth, imageHeight);
        if (this.tempXX.length < imageWidth) {
            this.tempXX = new float[imageWidth];
            this.tempXY = new float[imageWidth];
            this.tempYY = new float[imageWidth];
        }
    }

    @Override
    protected void horizontal() {
        float[] dataX = ((GrayF32)this.derivX).data;
        float[] dataY = ((GrayF32)this.derivY).data;
        float[] hXX = ((GrayF32)this.horizXX).data;
        float[] hXY = ((GrayF32)this.horizXY).data;
        float[] hYY = ((GrayF32)this.horizYY).data;
        int imgHeight = ((GrayF32)this.derivX).getHeight();
        int imgWidth = ((GrayF32)this.derivX).getWidth();
        int windowWidth = this.radius * 2 + 1;
        int radp1 = this.radius + 1;
        for (int row = 0; row < imgHeight; ++row) {
            float dy;
            float dx;
            int pix;
            int end = pix + windowWidth;
            float totalXX = 0.0f;
            float totalXY = 0.0f;
            float totalYY = 0.0f;
            int indexX = ((GrayF32)this.derivX).startIndex + row * ((GrayF32)this.derivX).stride;
            int indexY = ((GrayF32)this.derivY).startIndex + row * ((GrayF32)this.derivY).stride;
            for (pix = row * imgWidth; pix < end; ++pix) {
                dx = dataX[indexX++];
                dy = dataY[indexY++];
                totalXX += dx * dx;
                totalXY += dx * dy;
                totalYY += dy * dy;
            }
            hXX[pix - radp1] = totalXX;
            hXY[pix - radp1] = totalXY;
            hYY[pix - radp1] = totalYY;
            end = row * imgWidth + imgWidth;
            while (pix < end) {
                dx = dataX[indexX - windowWidth];
                dy = dataY[indexY - windowWidth];
                totalXX -= dx * dx;
                totalXY -= dx * dy;
                totalYY -= dy * dy;
                dx = dataX[indexX];
                dy = dataY[indexY];
                hXX[pix - this.radius] = totalXX += dx * dx;
                hXY[pix - this.radius] = totalXY += dx * dy;
                hYY[pix - this.radius] = totalYY += dy * dy;
                ++pix;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected void vertical(GrayF32 intensity) {
        int srcIndex;
        int destIndex;
        float[] hXX = ((GrayF32)this.horizXX).data;
        float[] hXY = ((GrayF32)this.horizXY).data;
        float[] hYY = ((GrayF32)this.horizYY).data;
        float[] inten = intensity.data;
        int imgHeight = ((GrayF32)this.horizXX).getHeight();
        int imgWidth = ((GrayF32)this.horizXX).getWidth();
        int kernelWidth = this.radius * 2 + 1;
        int startX = this.radius;
        int endX = imgWidth - this.radius;
        int backStep = kernelWidth * imgWidth;
        this.x = startX;
        while (this.x < endX) {
            destIndex = imgWidth * this.radius + this.x;
            this.totalYY = 0.0f;
            this.totalXY = 0.0f;
            this.totalXX = 0.0f;
            int indexEnd = srcIndex + imgWidth * kernelWidth;
            for (srcIndex = this.x; srcIndex < indexEnd; srcIndex += imgWidth) {
                this.totalXX += hXX[srcIndex];
                this.totalXY += hXY[srcIndex];
                this.totalYY += hYY[srcIndex];
            }
            this.tempXX[this.x] = this.totalXX;
            this.tempXY[this.x] = this.totalXY;
            this.tempYY[this.x] = this.totalYY;
            this.y = this.radius;
            inten[destIndex] = this.computeIntensity();
            destIndex += imgWidth;
            ++this.y;
            ++this.x;
        }
        this.y = this.radius + 1;
        while (this.y < imgHeight - this.radius) {
            srcIndex = (this.y + this.radius) * imgWidth + startX;
            destIndex = this.y * imgWidth + startX;
            this.x = startX;
            while (this.x < endX) {
                this.totalXX = this.tempXX[this.x] - hXX[srcIndex - backStep];
                this.tempXX[this.x] = this.totalXX += hXX[srcIndex];
                this.totalXY = this.tempXY[this.x] - hXY[srcIndex - backStep];
                this.tempXY[this.x] = this.totalXY += hXY[srcIndex];
                this.totalYY = this.tempYY[this.x] - hYY[srcIndex - backStep];
                this.tempYY[this.x] = this.totalYY += hYY[srcIndex];
                inten[destIndex] = this.computeIntensity();
                ++this.x;
                ++srcIndex;
                ++destIndex;
            }
            ++this.y;
        }
    }
}

