/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F32;

public class HoughTransformLineFootOfNorm {
    NonMaxSuppression extractor;
    FastQueue<LineParametric2D_F32> lines = new FastQueue(10, LineParametric2D_F32.class, true);
    int minDistanceFromOrigin;
    int originX;
    int originY;
    GrayF32 transform = new GrayF32(1, 1);
    QueueCorner foundLines = new QueueCorner(10);
    QueueCorner candidates = new QueueCorner(10);
    GrowQueue_F32 foundIntensity = new GrowQueue_F32(10);

    public HoughTransformLineFootOfNorm(NonMaxSuppression extractor, int minDistanceFromOrigin) {
        this.extractor = extractor;
        this.minDistanceFromOrigin = minDistanceFromOrigin;
    }

    public <D extends ImageGray> void transform(D derivX, D derivY, GrayU8 binary) {
        InputSanityCheck.checkSameShape(derivX, derivY, (ImageBase)binary);
        this.transform.reshape(derivX.width, derivY.height);
        ImageMiscOps.fill((GrayF32)this.transform, (float)0.0f);
        this.originX = derivX.width / 2;
        this.originY = derivX.height / 2;
        this.candidates.reset();
        if (derivX instanceof GrayF32) {
            this._transform((GrayF32)derivX, (GrayF32)derivY, binary);
        } else if (derivX instanceof GrayS16) {
            this._transform((GrayS16)derivX, (GrayS16)derivY, binary);
        } else if (derivX instanceof GrayS32) {
            this._transform((GrayS32)derivX, (GrayS32)derivY, binary);
        } else {
            throw new IllegalArgumentException("Unsupported derivative image type: " + derivX.getClass().getSimpleName());
        }
    }

    public FastQueue<LineParametric2D_F32> extractLines() {
        this.lines.reset();
        this.foundLines.reset();
        this.foundIntensity.reset();
        this.extractor.process(this.transform, null, this.candidates, null, this.foundLines);
        for (int i = 0; i < this.foundLines.size(); ++i) {
            Point2D_I16 p = (Point2D_I16)this.foundLines.get(i);
            int x0 = p.x - this.originX;
            int y0 = p.y - this.originY;
            if (Math.abs(x0) < this.minDistanceFromOrigin && Math.abs(y0) < this.minDistanceFromOrigin) continue;
            LineParametric2D_F32 l = (LineParametric2D_F32)this.lines.grow();
            l.p.set((float)p.x, (float)p.y);
            l.slope.set((float)(-y0), (float)x0);
            this.foundIntensity.push(this.transform.get((int)p.x, (int)p.y));
        }
        return this.lines;
    }

    public void parameterize(int x, int y, float derivX, float derivY) {
        float v = ((float)(x -= this.originX) * derivX + (float)(y -= this.originY) * derivY) / (derivX * derivX + derivY * derivY);
        int x0 = (int)(v * derivX) + this.originX;
        int y0 = (int)(v * derivY) + this.originY;
        if (this.transform.isInBounds(x0, y0)) {
            int index;
            int n = index = this.transform.startIndex + y0 * this.transform.stride + x0;
            float f = this.transform.data[n];
            this.transform.data[n] = f + 1.0f;
            if (f == 1.0f) {
                this.candidates.add(x0, y0);
            }
        }
    }

    public GrayF32 getTransform() {
        return this.transform;
    }

    public float[] getFoundIntensity() {
        return this.foundIntensity.data;
    }

    private void _transform(GrayF32 derivX, GrayF32 derivY, GrayU8 binary) {
        for (int y = 0; y < binary.height; ++y) {
            int start = binary.startIndex + y * binary.stride;
            int end = start + binary.width;
            for (int index = start; index < end; ++index) {
                if (binary.data[index] == 0) continue;
                int x = index - start;
                this.parameterize(x, y, derivX.unsafe_get(x, y), derivY.unsafe_get(x, y));
            }
        }
    }

    private void _transform(GrayS16 derivX, GrayS16 derivY, GrayU8 binary) {
        for (int y = 0; y < binary.height; ++y) {
            int start = binary.startIndex + y * binary.stride;
            int end = start + binary.width;
            for (int index = start; index < end; ++index) {
                if (binary.data[index] == 0) continue;
                int x = index - start;
                this.parameterize(x, y, derivX.unsafe_get(x, y), derivY.unsafe_get(x, y));
            }
        }
    }

    private void _transform(GrayS32 derivX, GrayS32 derivY, GrayU8 binary) {
        for (int y = 0; y < binary.height; ++y) {
            int start = binary.startIndex + y * binary.stride;
            int end = start + binary.width;
            for (int index = start; index < end; ++index) {
                if (binary.data[index] == 0) continue;
                int x = index - start;
                this.parameterize(x, y, derivX.unsafe_get(x, y), derivY.unsafe_get(x, y));
            }
        }
    }
}

