/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.slic;

import boofcv.alg.segmentation.slic.SegmentSlic;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class SegmentSlic_PlF32
extends SegmentSlic<Planar<GrayF32>> {
    public SegmentSlic_PlF32(int numberOfRegions, float m, int totalIterations, ConnectRule connectRule, int numBands) {
        super(numberOfRegions, m, totalIterations, connectRule, ImageType.pl((int)numBands, GrayF32.class));
    }

    @Override
    public void setColor(float[] color, int x, int y) {
        int numBands = ((Planar)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            color[i] = ((GrayF32)((Planar)this.input).getBand(i)).unsafe_get(x, y);
        }
    }

    @Override
    public void addColor(float[] color, int index, float weight) {
        int numBands = ((Planar)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            int n = i;
            color[n] = color[n] + ((GrayF32)((Planar)this.input).getBand((int)i)).data[index] * weight;
        }
    }

    @Override
    public float colorDistance(float[] color, int index) {
        int numBands = ((Planar)this.input).getNumBands();
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            float diff = ((GrayF32)((Planar)this.input).getBand((int)i)).data[index] - color[i];
            total += diff * diff;
        }
        return total;
    }

    @Override
    public float getIntensity(int x, int y) {
        int numBands = ((Planar)this.input).getNumBands();
        int index = ((Planar)this.input).getIndex(x, y);
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            total += ((GrayF32)((Planar)this.input).getBand((int)i)).data[index];
        }
        return total / (float)numBands;
    }
}

