/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.segmentation;

import boofcv.abst.segmentation.Fh04_to_ImageSuperpixels;
import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.abst.segmentation.MeanShift_to_ImageSuperpixels;
import boofcv.abst.segmentation.Slic_to_ImageSuperpixels;
import boofcv.abst.segmentation.Watershed_to_ImageSuperpixels;
import boofcv.alg.segmentation.fh04.SegmentFelzenszwalbHuttenlocher04;
import boofcv.alg.segmentation.ms.SegmentMeanShift;
import boofcv.alg.segmentation.slic.SegmentSlic;
import boofcv.alg.segmentation.watershed.WatershedVincentSoille1991;
import boofcv.factory.segmentation.ConfigFh04;
import boofcv.factory.segmentation.ConfigSegmentMeanShift;
import boofcv.factory.segmentation.ConfigSlic;
import boofcv.factory.segmentation.ConfigWatershed;
import boofcv.factory.segmentation.FactorySegmentationAlg;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class FactoryImageSegmentation {
    public static <T extends ImageBase> ImageSuperpixels<T> meanShift(ConfigSegmentMeanShift config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigSegmentMeanShift();
        }
        SegmentMeanShift<T> ms = FactorySegmentationAlg.meanShift(config, imageType);
        return new MeanShift_to_ImageSuperpixels<T>(ms, config.connectRule);
    }

    public static <T extends ImageBase> ImageSuperpixels<T> slic(ConfigSlic config, ImageType<T> imageType) {
        SegmentSlic<T> ms = FactorySegmentationAlg.slic(config, imageType);
        return new Slic_to_ImageSuperpixels<T>(ms);
    }

    public static <T extends ImageBase> ImageSuperpixels<T> fh04(ConfigFh04 config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigFh04();
        }
        SegmentFelzenszwalbHuttenlocher04<T> fh = FactorySegmentationAlg.fh04(config, imageType);
        return new Fh04_to_ImageSuperpixels<T>(fh, config.connectRule);
    }

    public static <T extends ImageBase> ImageSuperpixels<T> watershed(ConfigWatershed config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigWatershed();
        }
        WatershedVincentSoille1991 watershed = FactorySegmentationAlg.watershed(config.connectRule);
        Watershed_to_ImageSuperpixels<T> ret = new Watershed_to_ImageSuperpixels<T>(watershed, config.minimumRegionSize, config.connectRule);
        ret.setImageType(imageType);
        return ret;
    }
}

