/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.alg.shapes.ellipse.BinaryEllipseDetector;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetectorPixel;
import boofcv.alg.shapes.ellipse.EdgeIntensityEllipse;
import boofcv.alg.shapes.ellipse.SnapToEllipseEdge;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.alg.shapes.polygon.RefinePolygonCornersToImage;
import boofcv.alg.shapes.polygon.RefinePolygonLineToImage;
import boofcv.alg.shapes.polyline.SplitMergeLineFitLoop;
import boofcv.factory.shape.ConfigEllipseDetector;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.ConfigRefinePolygonCornersToImage;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.struct.image.ImageGray;

public class FactoryShapeDetector {
    public static <T extends ImageGray> BinaryEllipseDetector<T> ellipse(ConfigEllipseDetector config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigEllipseDetector();
        }
        config.checkValidity();
        BinaryEllipseDetectorPixel detector = new BinaryEllipseDetectorPixel();
        detector.setMaxDistanceFromEllipse(config.maxDistanceFromEllipse);
        detector.setMaximumContour(config.maximumContour);
        detector.setMinimumContour(config.minimumContour);
        detector.setInternalContour(config.processInternal);
        detector.setMaxMajorToMinorRatio(config.maxMajorToMinorRatio);
        SnapToEllipseEdge<T> refine = new SnapToEllipseEdge<T>(config.numSampleContour, config.refineRadialSamples, imageType);
        refine.setConvergenceTol(config.convergenceTol);
        refine.setMaxIterations(config.maxIterations);
        if (config.maxIterations <= 0 || config.numSampleContour <= 0) {
            refine = null;
        }
        EdgeIntensityEllipse<T> check = new EdgeIntensityEllipse<T>(config.checkRadialDistance, config.numSampleContour, config.checkIntensityThreshold, imageType);
        return new BinaryEllipseDetector<T>(detector, refine, check, imageType);
    }

    public static <T extends ImageGray> BinaryPolygonDetector<T> polygon(ConfigPolygonDetector config, Class<T> imageType) {
        config.checkValidity();
        SplitMergeLineFitLoop contourToPolygon = new SplitMergeLineFitLoop(config.contour2Poly_splitFraction, config.contour2Poly_minimumSideFraction, config.contour2Poly_iterations);
        RefineBinaryPolygon<T> refinePolygon = null;
        if (config.refine != null) {
            if (config.refine instanceof ConfigRefinePolygonLineToImage) {
                refinePolygon = FactoryShapeDetector.refinePolygon((ConfigRefinePolygonLineToImage)config.refine, imageType);
            } else if (config.refine instanceof ConfigRefinePolygonCornersToImage) {
                refinePolygon = FactoryShapeDetector.refinePolygon((ConfigRefinePolygonCornersToImage)config.refine, imageType);
            } else {
                throw new IllegalArgumentException("Unknown refine config type");
            }
        }
        return new BinaryPolygonDetector<T>(config.minimumSides, config.maximumSides, contourToPolygon, refinePolygon, config.minContourImageWidthFraction, config.clockwise, config.convex, config.canTouchBorder, config.splitPenalty, config.minimumEdgeIntensity, imageType);
    }

    public static <T extends ImageGray> RefineBinaryPolygon<T> refinePolygon(ConfigRefinePolygonLineToImage config, Class<T> imageType) {
        return new RefinePolygonLineToImage<T>(config.cornerOffset, config.lineSamples, config.sampleRadius, config.maxIterations, config.convergeTolPixels, config.maxCornerChangePixel, imageType);
    }

    public static <T extends ImageGray> RefineBinaryPolygon<T> refinePolygon(ConfigRefinePolygonCornersToImage config, Class<T> imageType) {
        return new RefinePolygonCornersToImage<T>(config.endPointDistance, config.cornerOffset, config.lineSamples, config.sampleRadius, config.maxIterations, config.convergeTolPixels, config.maxCornerChangePixel, imageType);
    }
}

