/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.dense;

import boofcv.abst.feature.dense.DescribeImageDense;
import boofcv.core.image.GConvertImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import java.util.List;

public class DescribeImageDense_Convert<T extends ImageBase, Desc extends TupleDesc>
implements DescribeImageDense<T, Desc> {
    DescribeImageDense<ImageBase, Desc> describer;
    ImageBase workspace;
    ImageType<T> inputType;

    public DescribeImageDense_Convert(DescribeImageDense<ImageBase, Desc> describer, ImageType<T> inputType) {
        ImageType<ImageBase> describerType = describer.getImageType();
        if (inputType.getFamily() != describerType.getFamily()) {
            throw new IllegalArgumentException("Image types must have the same family");
        }
        if (inputType.getDataType() == describerType.getDataType()) {
            throw new IllegalArgumentException("Data types are the same.  Why do you want to use this class?");
        }
        this.workspace = describerType.createImage(1, 1);
        this.describer = describer;
        this.inputType = inputType;
    }

    @Override
    public Desc createDescription() {
        return this.describer.createDescription();
    }

    @Override
    public Class<Desc> getDescriptionType() {
        return this.describer.getDescriptionType();
    }

    @Override
    public void process(T input) {
        this.workspace.reshape(((ImageBase)input).width, ((ImageBase)input).height);
        GConvertImage.convert(input, (ImageBase)this.workspace);
        this.describer.process(this.workspace);
    }

    @Override
    public List<Desc> getDescriptions() {
        return this.describer.getDescriptions();
    }

    @Override
    public List<Point2D_I32> getLocations() {
        return this.describer.getLocations();
    }

    @Override
    public ImageType<T> getImageType() {
        return this.inputType;
    }
}

