/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.ellipse;

import boofcv.alg.filter.binary.Contour;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetectorPixel;
import boofcv.alg.shapes.ellipse.EdgeIntensityEllipse;
import boofcv.alg.shapes.ellipse.SnapToEllipseEdge;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.shapes.EllipseRotated_F64;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class BinaryEllipseDetector<T extends ImageGray> {
    BinaryEllipseDetectorPixel ellipseDetector;
    SnapToEllipseEdge<T> ellipseRefiner;
    EdgeIntensityEllipse<T> intensityCheck;
    FastQueue<EllipseRotated_F64> refined = new FastQueue(EllipseRotated_F64.class, true);
    Class<T> inputType;
    boolean verbose = false;
    boolean autoRefine = true;

    public BinaryEllipseDetector(BinaryEllipseDetectorPixel ellipseDetector, SnapToEllipseEdge<T> ellipseRefiner, EdgeIntensityEllipse<T> intensityCheck, Class<T> inputType) {
        this.ellipseDetector = ellipseDetector;
        this.ellipseRefiner = ellipseRefiner;
        this.intensityCheck = intensityCheck;
        this.inputType = inputType;
    }

    public void setLensDistortion(PixelTransform2_F32 distToUndist, PixelTransform2_F32 undistToDist) {
        this.ellipseDetector.setLensDistortion(distToUndist);
        if (this.ellipseRefiner != null) {
            this.ellipseRefiner.setTransform(undistToDist);
        }
        this.intensityCheck.setTransform(undistToDist);
    }

    public void process(T gray, GrayU8 binary) {
        this.refined.reset();
        this.ellipseDetector.process(binary);
        if (this.ellipseRefiner != null) {
            this.ellipseRefiner.setImage(gray);
        }
        this.intensityCheck.setImage(gray);
        List<BinaryEllipseDetectorPixel.Found> found = this.ellipseDetector.getFound();
        for (BinaryEllipseDetectorPixel.Found f : found) {
            if (!this.intensityCheck.process(f.ellipse)) {
                if (!this.verbose) continue;
                System.out.println("Rejecting ellipse which isn't intense enough");
                continue;
            }
            EllipseRotated_F64 r = (EllipseRotated_F64)this.refined.grow();
            if (this.ellipseRefiner != null) {
                if (this.ellipseRefiner.process(f.ellipse, r)) continue;
                this.refined.removeTail();
                continue;
            }
            r.set(f.ellipse);
        }
    }

    public boolean refine(EllipseRotated_F64 ellipse) {
        if (this.autoRefine) {
            throw new IllegalArgumentException("Autorefine is true, no need to refine again");
        }
        if (this.ellipseRefiner == null) {
            throw new IllegalArgumentException("Refiner has not been passed in");
        }
        return this.ellipseRefiner.process(ellipse, ellipse);
    }

    public BinaryEllipseDetectorPixel getEllipseDetector() {
        return this.ellipseDetector;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAutoRefine() {
        return this.autoRefine;
    }

    public void setAutoRefine(boolean autoRefine) {
        this.autoRefine = autoRefine;
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public List<Contour> getAllContours() {
        return this.ellipseDetector.getContourFinder().getContours().toList();
    }

    public FastQueue<EllipseRotated_F64> getFoundEllipses() {
        return this.refined;
    }
}

