/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.template;

import boofcv.alg.feature.detect.template.TemplateCorrelationFFT;
import boofcv.alg.feature.detect.template.TemplateDiffSquared;
import boofcv.alg.feature.detect.template.TemplateMatching;
import boofcv.alg.feature.detect.template.TemplateMatchingIntensity;
import boofcv.alg.feature.detect.template.TemplateNCC;
import boofcv.factory.feature.detect.template.TemplateScoreType;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryTemplateMatching {
    public static <T extends ImageGray> TemplateMatchingIntensity<T> createIntensity(TemplateScoreType type, Class<T> imageType) {
        switch (type) {
            case SUM_DIFF_SQ: {
                if (imageType == GrayU8.class) {
                    return new TemplateDiffSquared.U8();
                }
                if (imageType == GrayF32.class) {
                    return new TemplateDiffSquared.F32();
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case NCC: {
                if (imageType == GrayU8.class) {
                    return new TemplateNCC.U8();
                }
                if (imageType == GrayF32.class) {
                    return new TemplateNCC.F32();
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
            case CORRELATION: {
                if (imageType == GrayF32.class) {
                    return new TemplateCorrelationFFT();
                }
                throw new IllegalArgumentException("Image type not supported. " + imageType.getSimpleName());
            }
        }
        throw new IllegalArgumentException("Type not found: " + (Object)((Object)type));
    }

    public static <T extends ImageGray> TemplateMatching<T> createMatcher(TemplateScoreType type, Class<T> imageType) {
        TemplateMatchingIntensity<T> intensity = FactoryTemplateMatching.createIntensity(type, imageType);
        return new TemplateMatching<T>(intensity);
    }
}

