/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.distort.PointTransform_F32;
import georegression.geometry.GeometryMath_F32;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Point2D_F32;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class AddRadialPtoP_F32
implements PointTransform_F32 {
    private float x_c;
    private float y_c;
    private float[] radial;
    private DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private Point2D_F32 temp0 = new Point2D_F32();

    public AddRadialPtoP_F32() {
    }

    public AddRadialPtoP_F32(double fx, double fy, double skew, double x_c, double y_c, double ... radial) {
        this.set(fx, fy, skew, x_c, y_c, radial);
    }

    public void set(double fx, double fy, double skew, double x_c, double y_c, double[] radial) {
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, x_c);
        this.K_inv.set(1, 2, y_c);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        this.x_c = (float)x_c;
        this.y_c = (float)y_c;
        if (radial == null) {
            this.radial = new float[0];
        } else {
            this.radial = new float[radial.length];
            for (int i = 0; i < radial.length; ++i) {
                this.radial[i] = (float)radial[i];
            }
        }
    }

    public void compute(float x, float y, Point2D_F32 out) {
        float r2;
        float sum = 0.0f;
        this.temp0.x = x;
        this.temp0.y = y;
        GeometryMath_F32.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F32)this.temp0, (GeoTuple2D_F32)out);
        float r = r2 = out.x * out.x + out.y * out.y;
        for (int i = 0; i < this.radial.length; ++i) {
            sum += this.radial[i] * r;
            r *= r2;
        }
        out.x = x + (x - this.x_c) * sum;
        out.y = y + (y - this.y_c) * sum;
    }
}

