/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F64;
import boofcv.struct.distort.PointTransform_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class AddRadialPtoN_F64
implements PointTransform_F64 {
    protected RadialTangential_F64 params;
    private DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private Point2D_F64 temp0 = new Point2D_F64();

    public AddRadialPtoN_F64 setK(double fx, double fy, double skew, double cx, double cy) {
        this.K_inv.zero();
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, cx);
        this.K_inv.set(1, 2, cy);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        return this;
    }

    public AddRadialPtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        double r2;
        float sum = 0.0f;
        double[] radial = this.params.radial;
        double t1 = this.params.t1;
        double t2 = this.params.t2;
        this.temp0.x = x;
        this.temp0.y = y;
        GeometryMath_F64.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F64)this.temp0, (GeoTuple2D_F64)out);
        double ri2 = r2 = out.x * out.x + out.y * out.y;
        for (int i = 0; i < radial.length; ++i) {
            sum = (float)((double)sum + radial[i] * ri2);
            ri2 *= r2;
        }
        double tx = 2.0 * t1 * out.x * out.y + t2 * (r2 + 2.0 * out.x * out.x);
        double ty = t1 * (r2 + 2.0 * out.y * out.y) + 2.0 * t2 * out.x * out.y;
        out.x = out.x * (double)(1.0f + sum) + tx;
        out.y = out.y * (double)(1.0f + sum) + ty;
    }
}

