/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo;

import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.NormalizedToPixel_F64;
import boofcv.alg.distort.PixelToNormalized_F64;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;

public class PerspectiveOps {
    public static void scaleIntrinsic(IntrinsicParameters param, double scale) {
        param.width = (int)((double)param.width * scale);
        param.height = (int)((double)param.height * scale);
        param.cx *= scale;
        param.cy *= scale;
        param.fx *= scale;
        param.fy *= scale;
        param.skew *= scale;
    }

    public static IntrinsicParameters adjustIntrinsic(IntrinsicParameters parameters, DenseMatrix64F adjustMatrix, IntrinsicParameters adjustedParam) {
        if (adjustedParam == null) {
            adjustedParam = new IntrinsicParameters();
        }
        DenseMatrix64F K = PerspectiveOps.calibrationMatrix(parameters, null);
        DenseMatrix64F K_adj = new DenseMatrix64F(3, 3);
        CommonOps.mult((RowD1Matrix64F)adjustMatrix, (RowD1Matrix64F)K, (RowD1Matrix64F)K_adj);
        PerspectiveOps.matrixToParam(K_adj, parameters.width, parameters.height, adjustedParam);
        return adjustedParam;
    }

    public static DenseMatrix64F calibrationMatrix(double fx, double fy, double skew, double xc, double yc) {
        return new DenseMatrix64F(3, 3, true, new double[]{fx, skew, xc, 0.0, fy, yc, 0.0, 0.0, 1.0});
    }

    public static DenseMatrix64F calibrationMatrix(IntrinsicParameters param, DenseMatrix64F K) {
        if (K == null) {
            K = new DenseMatrix64F(3, 3);
        }
        CommonOps.fill((D1Matrix64F)K, (double)0.0);
        K.data[0] = param.fx;
        K.data[1] = param.skew;
        K.data[2] = param.cx;
        K.data[4] = param.fy;
        K.data[5] = param.cy;
        K.data[8] = 1.0;
        return K;
    }

    public static IntrinsicParameters matrixToParam(DenseMatrix64F K, int width, int height, IntrinsicParameters param) {
        if (param == null) {
            param = new IntrinsicParameters();
        }
        param.fx = K.get(0, 0);
        param.fy = K.get(1, 1);
        param.skew = K.get(0, 1);
        param.cx = K.get(0, 2);
        param.cy = K.get(1, 2);
        param.width = width;
        param.height = height;
        return param;
    }

    public static Point2D_F64 convertNormToPixel(IntrinsicParameters param, double x, double y, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        PointTransform_F64 normToPixel = LensDistortionOps.transformPoint(param).distort_F64(false, true);
        normToPixel.compute(x, y, pixel);
        return pixel;
    }

    public static Point2D_F32 convertNormToPixel(IntrinsicParameters param, float x, float y, Point2D_F32 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F32();
        }
        PointTransform_F32 normToPixel = LensDistortionOps.transformPoint(param).distort_F32(false, true);
        normToPixel.compute(x, y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertNormToPixel(IntrinsicParameters param, Point2D_F64 norm, Point2D_F64 pixel) {
        return PerspectiveOps.convertNormToPixel(param, norm.x, norm.y, pixel);
    }

    public static Point2D_F64 convertNormToPixel(DenseMatrix64F K, Point2D_F64 norm, Point2D_F64 pixel) {
        if (pixel == null) {
            pixel = new Point2D_F64();
        }
        NormalizedToPixel_F64 alg = new NormalizedToPixel_F64();
        alg.set(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(norm.x, norm.y, pixel);
        return pixel;
    }

    public static Point2D_F64 convertPixelToNorm(IntrinsicParameters param, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        PointTransform_F64 pixelToNorm = LensDistortionOps.transformPoint(param).distort_F64(true, false);
        pixelToNorm.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F32 convertPixelToNorm(IntrinsicParameters param, Point2D_F32 pixel, Point2D_F32 norm) {
        if (norm == null) {
            norm = new Point2D_F32();
        }
        PointTransform_F32 pixelToNorm = LensDistortionOps.transformPoint(param).distort_F32(true, false);
        pixelToNorm.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 convertPixelToNorm(DenseMatrix64F K, Point2D_F64 pixel, Point2D_F64 norm) {
        if (norm == null) {
            norm = new Point2D_F64();
        }
        PixelToNormalized_F64 alg = new PixelToNormalized_F64();
        alg.set(K.get(0, 0), K.get(1, 1), K.get(0, 1), K.get(0, 2), K.get(1, 2));
        alg.compute(pixel.x, pixel.y, norm);
        return norm;
    }

    public static Point2D_F64 renderPixel(Se3_F64 worldToCamera, DenseMatrix64F K, Point3D_F64 X) {
        Point3D_F64 X_cam = new Point3D_F64();
        SePointOps_F64.transform((Se3_F64)worldToCamera, (Point3D_F64)X, (Point3D_F64)X_cam);
        if (X_cam.z <= 0.0) {
            return null;
        }
        Point2D_F64 norm = new Point2D_F64(X_cam.x / X_cam.z, X_cam.y / X_cam.z);
        if (K == null) {
            return norm;
        }
        return (Point2D_F64)GeometryMath_F64.mult((DenseMatrix64F)K, (GeoTuple2D_F64)norm, (GeoTuple2D_F64)norm);
    }

    public static Point2D_F64 renderPixel(IntrinsicParameters intrinsic, Point3D_F64 X) {
        Point2D_F64 norm = new Point2D_F64(X.x / X.z, X.y / X.z);
        return PerspectiveOps.convertNormToPixel(intrinsic, norm, norm);
    }

    public static Point2D_F64 renderPixel(DenseMatrix64F worldToCamera, Point3D_F64 X) {
        DenseMatrix64F P = worldToCamera;
        double x = P.data[0] * X.x + P.data[1] * X.y + P.data[2] * X.z + P.data[3];
        double y = P.data[4] * X.x + P.data[5] * X.y + P.data[6] * X.z + P.data[7];
        double z = P.data[8] * X.x + P.data[9] * X.y + P.data[10] * X.z + P.data[11];
        Point2D_F64 pixel = new Point2D_F64();
        pixel.x = x / z;
        pixel.y = y / z;
        return pixel;
    }

    public static void splitAssociated(List<AssociatedPair> pairs, List<Point2D_F64> view1, List<Point2D_F64> view2) {
        for (AssociatedPair p : pairs) {
            view1.add(p.p1);
            view2.add(p.p2);
        }
    }

    public static void splitAssociated(List<AssociatedTriple> pairs, List<Point2D_F64> view1, List<Point2D_F64> view2, List<Point2D_F64> view3) {
        for (AssociatedTriple p : pairs) {
            view1.add(p.p1);
            view2.add(p.p2);
            view3.add(p.p3);
        }
    }

    public static DenseMatrix64F createCameraMatrix(DenseMatrix64F R, Vector3D_F64 T, DenseMatrix64F K, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 4);
        }
        CommonOps.insert((RealMatrix64F)R, (RealMatrix64F)ret, (int)0, (int)0);
        ret.data[3] = T.x;
        ret.data[7] = T.y;
        ret.data[11] = T.z;
        if (K == null) {
            return ret;
        }
        DenseMatrix64F temp = new DenseMatrix64F(3, 4);
        CommonOps.mult((RowD1Matrix64F)K, (RowD1Matrix64F)ret, (RowD1Matrix64F)temp);
        ret.set((D1Matrix64F)temp);
        return ret;
    }

    public static WorldToCameraToPixel createWorldToPixel(IntrinsicParameters intrinsic, Se3_F64 worldToCamera) {
        WorldToCameraToPixel alg = new WorldToCameraToPixel();
        alg.configure(intrinsic, worldToCamera);
        return alg;
    }
}

